/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class TaskSetTemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.allTypes("taskSet", "tasksummaryitem"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.spark.UIFile;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport io.intino.goros.egeasy.box.ui.utils.Formatters;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.io.ByteArrayInputStream;\nimport java.io.InputStream;\nimport java.nio.charset.StandardCharsets;\nimport java.time.Instant;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\npublic class TaskSummaryItem extends AbstractTaskSummaryItem<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String _prefix;\n    private String _title;\n    private List<TaskSetItem> affectedTasks;\n\n    public TaskSummaryItem(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void refresh(String prefix, String title, List<TaskSetItem> lines) {\n        this._prefix = prefix;\n        this._title = title;\n        this.affectedTasks = lines;\n        refresh();\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        countLink.onExecute(e -> downloadLines());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(_title);\n        countLink.readonly(affectedTasks.size() == 0);\n        countLink.title(Formatters.formattedNumber(affectedTasks.size(), language()));\n    }\n\n    private UIFile downloadLines() {\n        return new UIFile() {\n            @Override\n            public String label() {\n                return _prefix + \"_\" + Formatters.downloadDate(Instant.now(), language(), \"tsv\");\n            }\n\n            @Override\n            public InputStream content() {\n                return new ByteArrayInputStream(String.join(\"\\n\", affectedTasks()).getBytes(StandardCharsets.UTF_8));\n            }\n\n            private List<String> affectedTasks() {\n                List<String> lines = affectedTasks.stream().map(this::lineOf).collect(Collectors.toList());\n                lines.add(0, headerLine());\n                return lines;\n            }\n\n            private String headerLine() {\n                StringBuilder result = new StringBuilder();\n                result.append(\"Nombre\").append(\"\t\");\n                result.append(\"Referencia\").append(\"\t\");\n                result.append(\"Objeto relacionado\").append(\"\t\");\n                result.append(\"Servicio web\").append(\"\t\");\n                result.append(\"Creador\").append(\"\t\");\n                result.append(\"Realizador\").append(\"\t\");\n                result.append(\"Proceso\").append(\"\t\");\n                result.append(\"Fecha de creaci\u00f3n\").append(\"\t\");\n                result.append(\"Fecha de caducidad\").append(\"\t\");\n                result.append(\"Fecha de aviso\").append(\"\t\");\n                result.append(\"Fecha de realizaci\u00f3n\").append(\"\t\");\n                result.append(\"Estado\").append(\"\t\");\n                result.append(\"Repetida\").append(\"\t\");\n                result.append(\"Dias restantes\");\n                return result.toString();\n            }\n\n            private String lineOf(TaskSetItem item) {\n                StringBuilder result = new StringBuilder();\n                result.append(item.name()).append(\"\t\");\n                result.append(item.reference() != null ? item.reference().name() : \"\").append(\"\t\");\n                result.append(item.relatedObject() != null ? item.relatedObject().name() : \"\").append(\"\t\");\n                result.append(emptyForNull(item.webService())).append(\"\t\");\n                result.append(emptyForNull(item.createdBy())).append(\"\t\");\n                result.append(emptyForNull(item.madeBy())).append(\"\t\");\n                result.append(item.process() != null ? item.process().name() : \"\").append(\"\t\");\n                result.append(emptyForNull(item.createDate())).append(\"\t\");\n                result.append(emptyForNull(item.dueDate())).append(\"\t\");\n                result.append(emptyForNull(item.adviseDate())).append(\"\t\");\n                result.append(emptyForNull(item.madeDate())).append(\"\t\");\n                result.append(item.state().title()).append(\"\t\");\n                result.append(item.repeated() ? \"S\u00ed\" : \"No\").append(\"\t\");\n                result.append(item.daysLeft());\n                return result.toString();\n            }\n\n            private String emptyForNull(String value) {\n                return value != null ? value : \"\";\n            }\n\n            private String emptyForNull(Instant value) {\n                return value != null ? Formatters.dateTime(value, language(), w -> translate(w)) : \"\";\n            }\n        };\n    }\n\n}")), this.rule().condition(this.allTypes("taskSet", "taskadvise"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.model.TaskAdvise;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class TaskAdviseTemplate extends AbstractTaskAdviseTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private TGTask task;\n    private TaskAdvise advise;\n    private Consumer<TaskAdvise> removeListener;\n\n    public TaskAdviseTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public TaskAdviseTemplate task(TGTask task) {\n        this.task = task;\n        return this;\n    }\n\n    public TaskAdviseTemplate advise(TaskAdvise advise) {\n        this.advise = advise;\n        return this;\n    }\n\n    public TaskAdviseTemplate onRemove(Consumer<TaskAdvise> listener) {\n        this.removeListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        remove.onExecute(e -> removeListener.accept(advise));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        createDate.value(advise.date());\n        message.value(advise.message());\n    }\n}")), this.rule().condition(this.allTypes("taskSet", "task"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.addressable.Addressed;\nimport io.intino.alexandria.ui.displays.events.AddItemEvent;\nimport io.intino.alexandria.ui.displays.events.actionable.OpenLayerEvent;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetItemDatasource;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetItemEvolutionDatasource;\nimport io.intino.goros.egeasy.box.ui.model.TaskAdvise;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport io.intino.goros.egeasy.box.ui.model.TaskState;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport io.intino.goros.egeasy.m3.entity.document.TGDocument;\nimport io.intino.goros.egeasy.m3.entity.field.TGField;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.m3.library.LibraryDocuments;\nimport io.intino.goros.egeasy.m3.library.LibraryTask;\nimport io.intino.goros.egeasy.m3.utils.DefinitionUtils;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.items.TaskEvolutionItem;\n\nimport java.io.InputStream;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\n\npublic class TaskTemplate extends AbstractTaskTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private TGRoom room;\n    private TGTask task;\n    private TGContainer taskTarget;\n    private String backTitle;\n    private Function<String, String> backAddressResolver;\n    private Consumer<TGTask> backListener;\n    private Consumer<TGTask> gotoTaskListener;\n    private Function<TGTask, ValidateResult> beforeFinishListener;\n    private Consumer<TGTask> beforeContinueWithWarnings;\n    private Consumer<ValidateResult> validationErrorsListener;\n    private TaskSetItemDatasource source;\n    private TaskSetItem selectedEvolutionTask;\n    private List<TaskSetItem> taskSelectorList;\n    private Mode mode = Mode.Full;\n    private String entityLayerAddress;\n    private ValidateResult warning;\n\n    public TaskTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public enum Mode { Full, Summary }\n\n    public void room(TGRoom room) {\n        this.room = room;\n    }\n\n    public void task(TGTask task) {\n        this.task = task;\n        this.taskTarget = task.getTargetIdentifier() != null && !task.getTargetIdentifier().isEmpty() ? (TGContainer) box().provider(session()).openResource(task.getTargetIdentifier().getERC(), task.getTargetIdentifier().getDRC()) : null;\n        this.source = new TaskSetItemDatasource(box().provider(session()), session(), task);\n    }\n\n    public void mode(Mode mode) {\n        this.mode = mode;\n    }\n\n    public void backInfo(String title, Function<String, String> addressResolver, Consumer<TGTask> listener) {\n        this.backTitle = title;\n        this.backAddressResolver = addressResolver;\n        this.backListener = listener;\n    }\n\n    public void onGotoTask(Consumer<TGTask> listener) {\n        this.gotoTaskListener = listener;\n    }\n\n    public void onBeforeFinish(Function<TGTask, ValidateResult> listener) {\n        this.beforeFinishListener = listener;\n    }\n\n    public void onBeforeContinueWithWarnings(Consumer<TGTask> listener) {\n        this.beforeContinueWithWarnings = listener;\n    }\n\n    public void onValidationErrors(Consumer<ValidateResult> listener) {\n        this.validationErrorsListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        linkDomain.onExecute(e -> {\n            if (backListener == null) return;\n            backListener.accept(task);\n        });\n        start.onExecute(e -> start());\n        entityLayerTrigger.onOpen(this::fillLayer);\n        continueTask.onExecute(e -> continueTask());\n        assign.onExecute(e -> assign());\n        finish.onExecute(e -> finish());\n        finishWithSign.onSign(e -> finishWithSign(e.signature()));\n        finishWithSign.beforeSignChecker(this::canSign);\n        finishWithSign.documentProvider(this::signatureDocument);\n        release.onExecute(e -> release());\n        abort.onExecute(e -> abort());\n        addAdvise.onExecute(e -> addAdvise());\n        taskSelectorDialog.onOpen(e -> refreshTaskSelectorDialog());\n        taskSelector.onSelect(e -> openTask.readonly(e.selection().isEmpty()));\n        openTask.onExecute(e -> open(taskSelector.selection()));\n        addAdviseDialog.onOpen(e -> refreshAdviseDialog());\n        taskStarterStamp.onStarted(e -> refreshTaskStarted());\n        taskStarterStamp.onCancel(e -> start.readonly(false));\n        taskStarterStamp.onError(e -> start.readonly(false));\n        finishEditionSelector.onSelect(e -> finishEdition());\n        taskFormDialog.onOpen(e -> refreshTaskFormDialog());\n        taskFormDialog.onClose(e -> cancelTaskForm());\n        acceptTaskForm.onExecute(e -> saveTaskForm());\n        warningDialog.onOpen(e -> {\n            warningDialogMessage.value(DisplayHelper.errorMessage(warning));\n            continueTaskWithWarnings.readonly(warning.getValidateError() == null || !warning.getValidateError().isWarning());\n        });\n        continueTaskWithWarnings.onExecute(e -> continueTaskWithWarnings());\n        initTaskEvolution();\n    }\n\n    private boolean canSign() {\n        if (taskTarget == null) return false;\n        TGField signableField = LibraryTask.findSignableField(task, taskTarget);\n        if (signableField == null) return false;\n        return box().provider(session()).checkAbilityToSign(taskTarget.getDRC(), signableField.getDRC());\n    }\n\n    private InputStream signatureDocument() {\n        finishWithSign.readonly(true);\n        ValidateResult result = beforeFinishListener != null ? beforeFinishListener.apply(task) : null;\n        if (!success(result)) {\n            notifyUser(\"Se necesita verificar los avisos pendientes\", UserMessage.Type.Info);\n            if (result != null && result.getValidateError() != null && !result.getValidateError().getFieldErrors().isEmpty()) validationErrorsListener.accept(result);\n            warning = result;\n            warningDialog.open();\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return null;\n        }\n        TGDocument document = LibraryDocuments.getDocument(taskTarget);\n        return box().provider(session()).openDocumentFile(taskTarget.getERC(), taskTarget.getDRC(), document.getDRC(), false);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        loadingBlock.visible(true);\n        icon.value(new java.io.File(box().egeConfiguration().iconsDir() + \"/Sistema/Task.ico\"));\n        iconCopy.text(DisplayHelper.entityInfo(task));\n        title.value(task.getName() != null ? task.getName() : \"Tarea\");\n        linkDomain.title(backTitle);\n        if (backAddressResolver != null && linkDomain instanceof Addressed) ((Addressed<?>)linkDomain).address(backAddressResolver);\n        processBlock.visible(mode == Mode.Full && task.getDomainIdentifier().isEmpty());\n        taskBlock.visible(mode == Mode.Full && !task.getDomainIdentifier().isEmpty());\n        infoBlock.visible(mode == Mode.Full);\n        finishWithSign.refresh();\n        refreshProcess();\n        refreshReference();\n        refreshRelatedObject();\n        refreshState();\n        repeatedBlock.visible(task.isRecovered());\n        refreshAdviseList();\n        loadingBlock.visible(false);\n    }\n\n    private void refreshProcess() {\n        taskEvolutionBlock.visible(mode == Mode.Full);\n        if (mode != Mode.Full) return;\n        TGIdentifier entity = task.getMainTaskIdentifier();\n        process.visible(entity != null);\n        if (entity == null) return;\n        //process.address(path -> path.replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC())));\n        process.onOpen(e -> {\n            entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC()));\n            fillLayer(entity, e);\n        });\n        process.title(entity.getName());\n        taskEvolutionList.source(new TaskSetItemEvolutionDatasource(box().provider(session()), session(), task));\n    }\n\n    private void refreshReference() {\n        if (mode != Mode.Full) return;\n        TGIdentifier entity = task.getMainTargetIdentifier();\n        reference.visible(entity != null);\n        if (entity == null) return;\n        //reference.address(path -> path.replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC())));\n        reference.onOpen(e -> {\n            entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC()));\n            fillLayer(entity, e);\n        });\n        reference.title(entity.getName());\n    }\n\n    private void refreshRelatedObject() {\n        relatedObjectBlock.visible(task.getTargetIdentifier() != null && !task.getTargetIdentifier().isEmpty());\n        if (mode != Mode.Full) return;\n        TGIdentifier entity = task.getTargetIdentifier();\n        relatedObject.visible(!entity.isEmpty());\n        //relatedObject.address(path -> path.replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC())));\n        relatedObject.onOpen(e -> {\n            entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC()));\n            fillLayer(entity, e);\n        });\n        relatedObject.title(entity.getName());\n    }\n\n    private void refreshState() {\n        TaskState state = TaskState.from(task.getStatus());\n        refreshPending(state);\n        refreshStarted(state);\n        refreshFinished(state);\n    }\n\n    private void refreshPending(TaskState state) {\n        pendingBlock.visible(state == TaskState.NotWorking);\n        if (state != TaskState.NotWorking) return;\n        boolean isProcess = task.getDomainIdentifier() == null || task.getDomainIdentifier().isEmpty();\n        pendingTitle.value(state.title());\n        pendingTitle.backgroundColor(state.color());\n        pendingCreateDate.value(task.getCreateDate() != null ? task.getCreateDate().toInstant() : null);\n        start.visible(!isProcess);\n    }\n\n    private void refreshStarted(TaskState state) {\n        startedBlock.visible(state == TaskState.Working);\n        if (state != TaskState.Working) return;\n        TGSessionInfo sessionInfo = box().provider(session()).sessionInfo();\n        TGField signableField = LibraryTask.findSignableField(task, taskTarget);\n        boolean sameUser = sessionInfo != null && sessionInfo.getURC() == task.getWorkUserIdentifier().getERC();\n        boolean isProcess = task.getDomainIdentifier() == null || task.getDomainIdentifier().isEmpty();\n        startedTitle.value(state.title());\n        startedTitle.backgroundColor(state.color());\n        startedCreateDate.value(task.getCreateDate() != null ? task.getCreateDate().toInstant() : null);\n        startedMadeDate.value(task.getWorkDate() != null ? task.getWorkDate().toInstant() : null);\n        TGIdentifier workUserIdentifier = task.getWorkUserIdentifier();\n        startedMadeUserBy.visible(!workUserIdentifier.isEmpty());\n        startedMadeUser.visible(!workUserIdentifier.isEmpty());\n        startedMadeUser.value(!workUserIdentifier.isEmpty() ? workUserIdentifier.getName() : null);\n        continueTask.visible(sameUser && mode == Mode.Full && !isProcess);\n        assign.visible(!sameUser && !isProcess);\n        finish.visible((sameUser || isProcess) && signableField == null);\n        finishWithSign.visible((sameUser || isProcess) && signableField != null);\n        release.visible(sameUser && !isProcess);\n        abort.visible(isProcess);\n    }\n\n    private void refreshFinished(TaskState state) {\n        finishedBlock.visible(state == TaskState.Finished || state == TaskState.Aborted);\n        if (state != TaskState.Finished && state != TaskState.Aborted) return;\n        finishedTitle.value(state.title());\n        finishedTitle.backgroundColor(state.color());\n        TGIdentifier workUserIdentifier = task.getWorkUserIdentifier();\n        finishedMadeDate.value(task.getWorkDate() != null ? task.getWorkDate().toInstant() : null);\n        finishedMadeUserBy.visible(!workUserIdentifier.isEmpty());\n        finishedMadeUser.visible(!workUserIdentifier.isEmpty());\n        finishedMadeUser.value(!workUserIdentifier.isEmpty() ? workUserIdentifier.getName() : null);\n        finishedCreateDate.value(task.getCreateDate() != null ? task.getCreateDate().toInstant() : null);\n    }\n\n    private void refreshAdviseList() {\n        adviseBlock.visible(false);\n        advises.clear();\n        source.advises(task).forEach(a -> fill(a, advises.add()));\n        adviseBlock.visible(true);\n    }\n\n    private void refreshAdviseDialog() {\n        adviseDateField.min(java.time.Instant.now());\n        adviseDateField.value(null);\n        adviseMessageField.value(null);\n    }\n\n    private void fill(TaskAdvise advise, TaskAdviseTemplate display) {\n        display.task(task);\n        display.advise(advise);\n        display.onRemove(e -> removeAdvise(advise));\n        display.refresh();\n    }\n\n    private void fillLayer(OpenLayerEvent event) {\n        fillLayer(task.getTargetIdentifier(), event);\n    }\n\n    private void fillLayer(TGIdentifier entity, OpenLayerEvent event) {\n        RoomTemplate template = new RoomTemplate(box());\n        event.layer().title(entity.getName());\n        event.layer().onBeforeClose(e -> template.checkDirty(e1 -> event.layer().close()));\n        event.layer().onClose(e -> updateTask());\n        event.layer().template(template);\n        gotoAddress();\n    }\n\n    private void gotoAddress() {\n        if (entityLayerAddress == null) return;\n        box().routeManager().routeDispatcher().dispatch(soul(), entityLayerAddress);\n        entityLayerAddress = null;\n    }\n\n    private void start() {\n        start.readonly(true);\n        taskStarterStamp.task(task);\n        taskStarterStamp.start();\n    }\n\n    private void refreshTaskStarted() {\n        task = (TGTask) box().provider(session()).openResource(this.task.getERC(), this.task.getDRC());\n        if (soul().display(RoomTemplate.class).isEmbedded()) {\n            box().routeManager().routeDispatcher().dispatch(soul(), \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n        }\n        else {\n            //entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n            entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task);\n            entityLayerTrigger.openLayer();\n            updateTask();\n        }\n        start.readonly(false);\n    }\n\n    private void continueTask() {\n        int rrc = task.getTargetIdentifier().getERC();\n        if (!box().provider(session()).isEditingResource(rrc)) {\n            io.intino.goros.egeasy.driver.driversystem.server.model.OperationResult operationResult = box().provider(session()).beginEditionResource(rrc);\n            if (!operationResult.isSuccess()) {\n                notifyUser(operationResult.getMessage(), io.intino.alexandria.ui.displays.UserMessage.Type.Error);\n                return;\n            }\n        }\n        if (soul().display(RoomTemplate.class).isEmbedded()) {\n            box().routeManager().routeDispatcher().dispatch(soul(), \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n        }\n        else {\n            //entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n            entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task);\n            entityLayerTrigger.openLayer();\n        }\n    }\n\n    private void assign() {\n        box().provider(session()).startWorkingTask(task.getERC(), task.getDRC(), false, false, null);\n        notifyUser(\"Tarea apropiada\", UserMessage.Type.Success);\n        //entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n        entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task);\n        entityLayerTrigger.openLayer();\n        updateTask();\n    }\n\n    private void finishWithSign(String signature) {\n        finishWithSign.readonly(true);\n        TGDocument document = LibraryDocuments.getDocument(taskTarget);\n        TGField signableField = LibraryTask.findSignableField(task, taskTarget);\n        notifyUser(\"Finalizando tarea...\", UserMessage.Type.Loading);\n        if (!box().provider(session()).saveDocumentSign(taskTarget.getERC(), taskTarget.getDRC(), document.getDRC(), signableField.getDRC(), signature)) {\n            notifyUser(\"No se ha podido finalizar la tarea\", UserMessage.Type.Error);\n            return;\n        }\n        doFinish();\n    }\n\n    private void finish() {\n        finish.readonly(true);\n        ValidateResult result = beforeFinishListener != null ? beforeFinishListener.apply(task) : null;\n        if (!success(result)) {\n            if (result.getValidateError().isWarning()) {\n                warning = result;\n                warningDialog.open();\n                notifyUser(\"Se necesita verificar los avisos pendientes\", UserMessage.Type.Info);\n            }\n            else notifyUser(\"No se ha podido guardar el elemento antes de finalizar\", UserMessage.Type.Error);\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        if (DefinitionUtils.hasTaskFields(task.getDefinition())) {\n            taskFormDialog.open();\n            return;\n        }\n        doFinish();\n    }\n\n    private void doFinish() {\n        notifyUser(\"Finalizando tarea...\", UserMessage.Type.Loading);\n        io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult validateResult = box().provider(session()).finishTask(task.getERC(), task.getDRC(), false);\n        if (!success(validateResult)) {\n            notifyUser(\"Se necesita verificar los avisos pendientes\", UserMessage.Type.Info);\n            if (validateResult != null && validateResult.getValidateError() != null && !validateResult.getValidateError().getFieldErrors().isEmpty()) validationErrorsListener.accept(validateResult);\n            warning = validateResult;\n            warningDialog.open();\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(task.getMainTaskIdentifier().getERC());\n        taskSelectorList = set != null ? io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource.itemsOf(set) : java.util.Collections.emptyList();\n        notifyUser(\"Tarea finalizada\", UserMessage.Type.Success);\n        finish.readonly(false);\n        finishWithSign.readonly(false);\n        updateTask();\n        if (taskSelectorList.isEmpty() && soul().display(RoomTemplate.class).isEmbedded()) finishEditionDialog.open();\n        else if (taskSelectorList.size() > 1) taskSelectorDialog.open();\n        else if (taskSelectorList.size() == 1) open(taskSelectorList.get(0));\n    }\n\n    private void continueTaskWithWarnings() {\n        notifyUser(\"Finalizando tarea...\", UserMessage.Type.Loading);\n        if (beforeContinueWithWarnings != null) beforeContinueWithWarnings.accept(task);\n        warningDialog.close();\n        box().provider(session()).finishTask(task.getERC(), task.getDRC(), true);\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(task.getMainTaskIdentifier().getERC());\n        taskSelectorList = set != null ? io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource.itemsOf(set) : java.util.Collections.emptyList();\n        notifyUser(\"Tarea finalizada\", UserMessage.Type.Success);\n        finish.readonly(false);\n        finishWithSign.readonly(false);\n        updateTask();\n        if (taskSelectorList.isEmpty() && soul().display(RoomTemplate.class).isEmbedded()) finishEditionDialog.open();\n        else if (taskSelectorList.size() > 1) taskSelectorDialog.open();\n        else if (taskSelectorList.size() == 1) open(taskSelectorList.get(0));\n    }\n\n    private void open(List<String> selection) {\n        if (selection.isEmpty()) return;\n        open(taskSelectorList.stream().filter(t -> t.name().equals(selection.get(0))).findFirst().orElse(null));\n    }\n\n    private void open(TaskSetItem taskItem) {\n        open((TGTask) box().provider(session()).openResource(taskItem.rrc(), taskItem.drc()));\n    }\n\n    private void open(TGTask task) {\n        taskSelectorDialog.close();\n        gotoTask(task);\n    }\n\n    private void refreshRecoverTaskDialog() {\n        recoverMessageField.value(null);\n    }\n\n    private void refreshTaskSelectorDialog() {\n        taskSelector.clear();\n        taskSelector.select();\n        taskSelector.addAll(taskSelectorList.stream().map(TaskSetItem::name).collect(Collectors.toList()));\n    }\n\n    private String labelOf(TGTask task) {\n        return task.getName();\n    }\n\n    private void release() {\n        RoomTemplate roomTemplate = soul().display(RoomTemplate.class);\n        boolean result = roomTemplate.checkDirty(e -> doRelease());\n        if (result) {\n            doRelease();\n            roomTemplate.entities.readonly(true);\n            roomTemplate.entities.refresh();\n        }\n    }\n\n    private void doRelease() {\n        if (!box().provider(session()).stopWorkingTask(task.getERC(), task.getDRC())) {\n            notifyUser(\"No se ha podido abandonar la tarea\", UserMessage.Type.Error);\n            return;\n        }\n        notifyUser(\"Tarea abandonada\", UserMessage.Type.Success);\n        updateTask();\n    }\n\n    private void abort() {\n        if (!box().provider(session()).abortTask(task.getERC(), task.getDRC())) {\n            notifyUser(\"No se ha podido abortar el proceso\", UserMessage.Type.Error);\n            return;\n        }\n        notifyUser(\"Tarea abortada\", UserMessage.Type.Success);\n        updateTask();\n    }\n\n    private void updateTask() {\n        task = (TGTask) box().provider(session()).openResource(task.getERC(), task.getDRC());\n        refresh();\n    }\n\n    private void addAdvise() {\n        if (!checkAdviseDialog()) return;\n        addAdviseDialog.close();\n        TaskAdvise advise = new TaskAdvise();\n        advise.date(adviseDateField.value());\n        advise.message(adviseMessageField.value());\n        source.add(task, advise);\n        refreshAdviseList();\n    }\n\n    private boolean checkAdviseDialog() {\n        adviseMessageField.error(null);\n        if (adviseDateField.value() == null) {\n            notifyUser(\"Indique una fecha\", UserMessage.Type.Error);\n            return false;\n        }\n        if (adviseMessageField.value() == null || adviseMessageField.value().isEmpty()) {\n            adviseMessageField.error(\"Indique un mensaje\");\n            return false;\n        }\n        return true;\n    }\n\n    private void removeAdvise(TaskAdvise advise) {\n        source.delete(task, advise);\n        refreshAdviseList();\n    }\n\n    private void initTaskEvolution() {\n        taskEvolutionList.onAddItem(this::refreshEvolutionItem);\n        taskEvolutionList.onSelect(e -> refreshEvolutionToolbar(e.selection()));\n        recoverTaskDialog.onOpen(e -> refreshRecoverTaskDialog());\n        recoverTask.onExecute(e -> recoverTask());\n    }\n\n    private void recoverTask() {\n        String message = recoverMessageField.value();\n        recoverTaskDialog.close();\n        notifyUser(\"Retrocediendo la tarea...\", UserMessage.Type.Loading);\n        boolean recovered = box().provider(session()).recoverTask(selectedEvolutionTask.rrc(), selectedEvolutionTask.drc(), message != null ? message : \"\");\n        if (!recovered) {\n            notifyUser(\"No se ha podido retroceder a la tarea \" + selectedEvolutionTask.name(), UserMessage.Type.Error);\n            return;\n        }\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(task.getMainTaskIdentifier().getERC());\n        taskSelectorList = set != null ? io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource.itemsOf(set) : java.util.Collections.emptyList();\n        notifyUser(\"Se ha retrocedido la tarea\", UserMessage.Type.Success);\n        if (taskSelectorList.size() > 1) taskSelectorDialog.open();\n        else if (taskSelectorList.size() == 1) open(taskSelectorList.get(0));\n        else updateTask();\n    }\n\n    private void refreshEvolutionToolbar(List<TaskSetItem> selection) {\n        selectedEvolutionTask = !selection.isEmpty() ? selection.get(0) : null;\n        recoverTaskTrigger.readonly(selectedEvolutionTask == null || selectedEvolutionTask.isProcess());\n    }\n\n    private void refreshEvolutionItem(AddItemEvent event) {\n        TaskSetItem task = event.item();\n        TaskState state = task.state();\n        boolean currentTask = task.rrc() == this.task.getERC();\n        TaskEvolutionItem display = event.component();\n        display.state.value(task.state() != null ? task.state().title() : null);\n        display.state.backgroundColor(task.state() != null ? task.state().color() : \"transparent\");\n        display.title.visible(currentTask);\n        if (currentTask) display.title.value(task.name());\n        display.titleLink.visible(!currentTask);\n        if (!currentTask) {\n            display.titleLink.title(task.name());\n            display.titleLink.onExecute(e -> open(task));\n        }\n        display.createDate.visible(state != TaskState.Finished && state != TaskState.Aborted);\n        if (display.createDate.isVisible()) display.createDate.value(task.createDate());\n        display.finishedDate.visible(state == TaskState.Finished || state == TaskState.Aborted);\n        if (display.finishedDate.isVisible()) display.finishedDate.value(task.madeDate());\n    }\n\n    private void gotoTask(TGTask task) {\n        if (gotoTaskListener != null) {\n            gotoTaskListener.accept(task);\n            return;\n        }\n        box().routeManager().routeDispatcher().dispatch(soul(), \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getDRC())).replace(\":rrc\", String.valueOf(task.getERC())));\n    }\n\n    private void finishEdition() {\n        List<String> selection = finishEditionSelector.selection();\n        if (selection.isEmpty()) return;\n        if (!selection.get(0).equals(\"closeOption\")) return;\n        soul().currentLayer().close();\n    }\n\n    private void refreshTaskFormDialog() {\n        taskFormDialog.title(task.getName() != null ? task.getName() : \"Tarea\");\n        entitiesStamp.entity(task);\n        entitiesStamp.view(\"form\");\n        entitiesStamp.readonly(false);\n        entitiesStamp.refresh();\n    }\n\n    private void cancelTaskForm() {\n        finish.readonly(false);\n        finishWithSign.readonly(false);\n    }\n\n    private void saveTaskForm() {\n        taskFormDialog.close();\n        ValidateResult result = entitiesStamp.save();\n        if (!success(result)) {\n            notifyUser(\"Ha habido un problema al finalizar\", UserMessage.Type.Error);\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        doFinish();\n    }\n\n    private boolean success(ValidateResult result) {\n        return result != null && result.success() && (result.getValidateError() == null || result.getValidateError().getMessage().isEmpty());\n    }\n}")), this.rule().condition(this.allTypes("taskSet", "catalog"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\nimport io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;\nimport io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetGridDatasource;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.TGEntity;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.provider.Provider;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Set;\n\nimport static java.util.stream.Collectors.toList;\nimport static ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates.TaskSetCatalogTemplate.OpenMode.Link;\n\npublic class TaskSetCatalogTemplate extends AbstractTaskSetCatalogTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String room;\n    private String section;\n    private TGEntity entity;\n    private TaskSetItem selectedTask;\n    private String taskSetName;\n    private OpenMode openMode = Link;\n    private Set<String> visibleColumns;\n    private TaskSetCatalogTemplate.FinishSummary finishSummary = null;\n    private String taskLayerAddress;\n\n    public enum OpenMode { Link, Layer };\n\n    public TaskSetCatalogTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void room(TGRoom room, String name) {\n        this.room = name;\n    }\n\n    public void section(String section) {\n        this.section = section;\n    }\n\n    public void entity(TGEntity entity) {\n        this.entity = entity;\n    }\n\n    public void openMode(OpenMode mode) {\n        this.openMode = mode;\n    }\n\n    public void taskSetName(String name) {\n        this.taskSetName = name;\n    }\n\n    public void visibleColumns(Set<String> visibleColumns) {\n        this.visibleColumns = visibleColumns;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        taskLayerTrigger.onOpen(e -> fillLayer(e.layer()));\n        refresh.onExecute(e -> refreshGrid());\n        finishSelection.onExecute(this::finishSelection);\n        initGrid();\n        finishSummaryDialog.onOpen(e -> refreshFinishSummaryDialog());\n        initExport();\n    }\n\n    private void initGrid() {\n        taskGrid.onSelect(e -> exportWizard.mode(e.selection().isEmpty() ? ExportWizard.Mode.Set : ExportWizard.Mode.File));\n        taskGrid.onSortColumn(event -> {\n            GridColumn<TaskSetItem> column = event.column();\n            SortColumnEvent.Mode mode = event.mode();\n            taskGrid.sortings(mode != SortColumnEvent.Mode.None ? List.of(column.label() + \"=\" + (mode == SortColumnEvent.Mode.Ascendant ? \"A\" : \"D\")) : Collections.emptyList());\n        });\n        taskGrid.onClickCell(e -> open(e.item()));\n        taskGrid.itemResolver(new Grid.ItemResolver<>() {\n            @Override\n            public GridItem build(TaskSetItem item) {\n                GridItem result = new GridItem();\n                result.add(item.name());\n                result.add(item.reference() != null ? item.reference().name() : \"\");\n                result.add(item.relatedObject() != null ? item.relatedObject().name() : \"\");\n                result.add(item.webService());\n                result.add(item.createdBy());\n                result.add(item.madeBy());\n                result.add(item.process() != null ? item.process().name() : \"\");\n                result.add(item.createDate());\n                result.add(item.dueDate());\n                result.add(item.adviseDate());\n                result.add(item.madeDate());\n                result.add(item.state().title());\n                result.add(item.repeated() ? \"S\u00ed\" : \"No\");\n                result.add(item.daysLeft());\n                return result;\n            }\n\n            @Override\n            public String address(GridColumn<TaskSetItem> column, TaskSetItem item) {\n                if (column.type() != GridColumn.Type.Link) return null;\n                if (column.address() == null) return null;\n                return session().browser().basePath() + column.address().replace(\":name\", StringUtil.encode(room)).replace(\":section\", section).replace(\":location\", taskSetName).replace(\":drc\", String.valueOf(item.drc())).replace(\":rrc\", String.valueOf(item.rrc())).replace(\":view\", \"default\");\n            }\n        });\n        taskGrid.onRefreshItemCount(this::refreshCount);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshVisibleColumns();\n        taskGrid.source(new TaskSetGridDatasource(box().provider(session()), session(), entity));\n        refreshCount(taskGrid.itemCount());\n        refreshExport();\n    }\n\n    private void initExport() {\n        exportWizard.onExportFile(mode -> box().provider(session()).exportTaskDocuments(DisplayHelper.tasksIdentifiersOf(taskGrid.selectedItems()).toArray(new TGIdentifier[0])));\n        exportWizard.onExportSet(mode -> ((TaskSetGridDatasource)taskGrid.source()).export(mode, taskGrid.visibleColumns().stream().map(io.intino.alexandria.ui.model.datasource.grid.GridColumn::label).collect(java.util.stream.Collectors.toList())));\n    }\n\n    private void refreshVisibleColumns() {\n        taskGrid.visibleColumns(taskGrid.columns().stream().peek(c -> c.visible(visibleColumns == null || visibleColumns.contains(c.name()))).collect(toList()));\n    }\n\n    private void refreshFinishSummaryDialog() {\n        if (finishSummary == null) return;\n        totalCount.value(finishSummary.count());\n        finishedSummaryItem.refresh(\"finished\", translate(\"finalizadas\"), finishSummary.finished);\n        notFinishedSummaryItem.refresh(\"not-finished\", translate(\"no finalizadas\"), finishSummary.notFinished);\n    }\n\n    private void refreshGrid() {\n        taskGrid.reload();\n    }\n\n    private void finishSelection(SelectionEvent event) {\n        try {\n            notifyUser(\"Finalizando tareas\", UserMessage.Type.Loading);\n            Provider provider = box().provider(session());\n            List<TaskSetItem> selection = event.selection();\n            finishSummary = new TaskSetCatalogTemplate.FinishSummary();\n            selection.forEach(e -> {\n                if (provider.finishTask(e.rrc(), e.drc(), false).success()) finishSummary.finished.add(e);\n                else finishSummary.notFinished.add(e);\n            });\n            taskGrid.reload();\n            finishSummaryDialog.open();\n        }\n        finally {\n            notifyUser(\"Tareas finalizadas\", UserMessage.Type.Success);\n        }\n    }\n\n    private void refreshCount(RefreshCountEvent event) {\n        refreshCount(event.count());\n    }\n\n    private void refreshCount(long count) {\n        this.count.value(DisplayHelper.countMessage(count, \"tarea\", \"tareas\"));\n    }\n\n    private void refreshExport() {\n        exportWizard.filename(entity.getName() + \" \" + DisplayHelper.downloadDate());\n        exportWizard.mode(ExportWizard.Mode.Set);\n        exportWizard.entity(entity);\n        exportWizard.refresh();\n    }\n\n    private static class FinishSummary {\n        public List<TaskSetItem> finished = new ArrayList<>();\n        public List<TaskSetItem> notFinished = new ArrayList<>();\n\n        public int count() {\n            return finished.size() + notFinished.size();\n        }\n    }\n\n    private void open(TaskSetItem task) {\n        if (task == null) return;\n        selectedTask = task;\n        if (openMode == Link) {\n            taskLinkTrigger.address(path -> path.replace(\":name\", StringUtil.encode(room)).replace(\":section\", section).replace(\":location\", taskSetName).replace(\":drc\", String.valueOf(task.drc())).replace(\":rrc\", String.valueOf(task.rrc())).replace(\":view\", \"default\"));\n            taskLinkTrigger.launch();\n        } else {\n            //taskLayerTrigger.address(path -> path.replace(\":rrc\", String.valueOf(task.rrc())).replace(\":drc\", String.valueOf(task.drc())));\n            taskLayerAddress = \"/entidad/:rrc/:drc\".replace(\":rrc\", String.valueOf(task.rrc())).replace(\":drc\", String.valueOf(task.drc()));\n            taskLayerTrigger.openLayer();\n        }\n    }\n\n    private void fillLayer(Layer<?, ?> layer) {\n        RoomTemplate template = new RoomTemplate(box());\n        template.readonly(true);\n        template.onRemove(e -> {\n            soul().currentLayer().close();\n            refreshGrid();\n        });\n        layer.title(selectedTask.name());\n        layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n        layer.template(template);\n        box().routeManager().routeDispatcher().dispatch(soul(), taskLayerAddress);\n    }\n\n}")), this.rule().condition(this.allTypes("taskSet", "starter"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.events.Event;\nimport io.intino.goros.egeasy.m3.definition.base.Definition;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.m3.library.LibraryEntity;\nimport io.intino.goros.egeasy.provider.Provider;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class TaskStarterTemplate extends AbstractTaskStarterTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private TGTask task;\n    private Consumer<TGTask> startedListener;\n    private Consumer<TGTask> cancelListener;\n    private Consumer<TGTask> errorListener;\n    private boolean reuseTarget = false;\n    private boolean copySignedTarget = false;\n    private Definition selectedContainerType = null;\n    private TaskQuery taskQuery = null;\n    private String taskQueryMessage = null;\n    private TaskResponse taskResponse = null;\n\n    public TaskStarterTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public enum TaskQuery {\n        CreateNew(\"Ya existe contenedor '%s'. \u00bfDesea crear uno nuevo?\"),\n        CreateCopy(\"El documento ya est\u00e1 %s. \u00bfDesea crear una copia?\");\n        private String title;\n        TaskQuery(String title) {\n            this.title = title;\n        }\n        public String title() {\n            return title;\n        }\n    }\n    public enum TaskResponse { No, Yes }\n\n    @Override\n    public void init() {\n        super.init();\n        queryDialogResponseNo.onExecute(e -> checkStartResponse(TaskResponse.No));\n        queryDialogResponseYes.onExecute(e -> checkStartResponse(TaskResponse.Yes));\n        containerTypeSelector.onSelect(e -> selectContainerType.readonly(e.selection().isEmpty()));\n        containerTypeSelectorDialog.onOpen(e -> refreshContainerTypeSelectorDialog());\n        containerTypeSelectorDialog.onClose(e -> notifyCancel());\n        selectContainerType.onExecute(this::updateSelectedContainerType);\n        queryDialog.onOpen(e -> queryDialogMessage.value(taskQueryMessage));\n    }\n\n    public void task(TGTask task) {\n        this.task = task;\n        this.reuseTarget = false;\n        this.copySignedTarget = false;\n        this.selectedContainerType = null;\n    }\n\n    public void onStarted(Consumer<TGTask> listener) {\n        this.startedListener = listener;\n    }\n\n    public void onCancel(Consumer<TGTask> listener) {\n        this.cancelListener = listener;\n    }\n\n    public void onError(Consumer<TGTask> listener) {\n        this.errorListener = listener;\n    }\n\n    public void start() {\n        if (!canStart()) return;\n        doStart();\n    }\n\n    private boolean canStart() {\n        if (task.getTargetIdentifier() != null && !task.getTargetIdentifier().isEmpty()) return true;\n        if (!task.isRecovered()) {\n            selectContainerType();\n            return false;\n        }\n        TGTask recoveredTask = (TGTask) box().provider(session()).openResource(task.getRecoveredTaskIdentifier().getERC(), task.getRecoveredTaskIdentifier().getDRC());\n        if (recoveredTask.getTargetIdentifier() == null || recoveredTask.getTargetIdentifier().isEmpty()) {\n            selectContainerType();\n            return false;\n        }\n        requestCreateNewTarget(recoveredTask.getTargetIdentifier());\n        return false;\n    }\n\n    private void selectContainerType() {\n        List<Definition> types = containerTypes();\n        if (types.size() == 0) {\n            notifyUser(\"No se han definido tipos de contenedor\", UserMessage.Type.Error);\n            return;\n        }\n        if (types.size() == 1) {\n            selectedContainerType = types.get(0);\n            doStart();\n            return;\n        }\n        containerTypeSelectorDialog.open();\n    }\n\n    private void requestCreateNewTarget(TGIdentifier container) {\n        taskQuery = TaskQuery.CreateNew;\n        taskQueryMessage = TaskQuery.CreateNew.title().replace(\"%s\", container.getName());\n        queryDialog.open();\n    }\n\n    private void checkStartResponse(TaskResponse response) {\n        queryDialog.close();\n        if (taskQuery == TaskQuery.CreateNew) {\n            reuseTarget = response == TaskResponse.No;\n            if (reuseTarget) requestCreateCopy();\n            else selectContainerType();\n        }\n        else if (taskQuery == TaskQuery.CreateCopy) {\n            copySignedTarget = response == TaskResponse.Yes;\n            doStart();\n        }\n    }\n\n    private void requestCreateCopy() {\n        Provider provider = box().provider(session());\n        TGTask recoveredTask = (TGTask) provider.openResource(task.getRecoveredTaskIdentifier().getERC(), task.getRecoveredTaskIdentifier().getDRC());\n        TGResource resource = provider.openResource(recoveredTask.getTargetIdentifier().getERC(), recoveredTask.getTargetIdentifier().getDRC());\n        if (LibraryEntity.isSigned(resource) || LibraryEntity.isApproved(resource)) {\n            taskQuery = TaskQuery.CreateCopy;\n            taskQueryMessage = TaskQuery.CreateCopy.title().replace(\"%s\", LibraryEntity.isSigned(resource) ? \"firmado\" : \"validado\");\n            queryDialog.open();\n            return;\n        }\n        copySignedTarget = false;\n        doStart();\n    }\n\n    private void doStart() {\n        int rrc = task.getTargetIdentifier().getERC();\n        if (!box().provider(session()).isEditingResource(rrc)) {\n            io.intino.goros.egeasy.driver.driversystem.server.model.OperationResult operationResult = box().provider(session()).beginEditionResource(rrc);\n            if (!operationResult.isSuccess()) {\n                notifyUser(operationResult.getMessage(), io.intino.alexandria.ui.displays.UserMessage.Type.Error);\n                errorListener.accept(task);\n                return;\n            }\n        }\n        io.intino.goros.egeasy.driver.driversystem.server.model.OperationResult operationResult = box().provider(session()).startWorkingTask(task.getERC(), task.getDRC(), reuseTarget, copySignedTarget, selectedContainerType);\n        if (!operationResult.isSuccess()) {\n            notifyUser(operationResult.getMessage(), UserMessage.Type.Error);\n            errorListener.accept(task);\n            return;\n        }\n        this.startedListener.accept(task);\n    }\n\n    private void refreshContainerTypeSelectorDialog() {\n        containerTypeSelector.clear();\n        containerTypeSelector.addAll(containerTypes().stream().map(Definition::getCaption).collect(Collectors.toList()));\n    }\n\n    private Definition selectedContainerType() {\n        List<String> selection = containerTypeSelector.selection();\n        if (selection.isEmpty()) return null;\n        String selected = selection.get(0);\n        return containerTypes().stream().filter(d -> d.getCaption().equals(selected)).findFirst().orElse(null);\n    }\n\n    private void updateSelectedContainerType(Event e) {\n        selectContainerType.readonly(true);\n        selectedContainerType = selectedContainerType();\n        if (selectedContainerType == null) {\n            notifyUser(\"Debe seleccionar un tipo de contenedor para la tarea\", UserMessage.Type.Warning);\n            selectContainerType.readonly(false);\n            return;\n        }\n        selectContainerType.readonly(false);\n        containerTypeSelectorDialog.close();\n        doStart();\n    }\n\n    private List<Definition> containerTypes() {\n        return box().provider(session()).loadAvailableTargets(task.getERC(), task.getDRC());\n    }\n\n    private void notifyCancel() {\n        if (cancelListener == null) return;\n        cancelListener.accept(task);\n    }\n\n}")), this.rule().condition(this.type("taskSet"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.RoomLocationContainer;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport io.intino.goros.egeasy.m3.entity.room.TGLocation;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("boxName", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.function.Consumer;\n\npublic class TaskSetTemplate extends AbstractTaskSetTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> implements RoomLocationContainer {\n    private String label;\n    private int rrc;\n    private TGRoom room;\n    private String roomName;\n    private TGTaskSet taskSet;\n    private String taskSetName;\n    private TGTask selectedTask;\n\n    public TaskSetTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public TaskSetTemplate label(String label) {\n        this.label = label;\n        return this;\n    }\n\n    public TaskSetTemplate rrc(int rrc) {\n        this.rrc = rrc;\n        return this;\n    }\n\n    public void room(TGRoom room, String name) {\n        this.room = room;\n        this.roomName = name;\n        taskSetCatalogStamp.searchBox.condition(null);\n    }\n\n    @Override\n    public void section(Section section) {\n    }\n\n    @Override\n    public void location(TGLocation location, String name) {\n    }\n\n    @Override\n    public void open(int drc, int rrc, String view) {\n        loadingContent.show();\n        open((TGTask) box().provider(session()).openResource(rrc, drc));\n        loadingContent.hide();\n    }\n\n    @Override\n    public void back() {\n        showTasksBlock();\n        taskSetCatalogStamp.refresh();\n    }\n\n    @Override\n    public boolean checkDirty(Consumer<Boolean> saveListener) {\n        return true;\n    }\n\n    public TaskSetTemplate taskSet(TGTaskSet taskSet, String name) {\n        this.taskSet = taskSet;\n        this.taskSetName = name;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        taskBlock.onShow(e -> refreshTaskBlock());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        icon.value(new java.io.File(box().egeConfiguration().iconsDir() + \"/Sistema/TaskTray.ico\"));\n        title.value(label);\n        showTasksBlock();\n        refreshCatalog();\n    }\n\n    private void refreshCatalog() {\n        taskSetCatalogStamp.room(room, roomName);\n        taskSetCatalogStamp.section(\"Tareas\");\n        taskSetCatalogStamp.entity(taskSet);\n        taskSetCatalogStamp.taskSetName(taskSetName);\n        taskSetCatalogStamp.visibleColumns(visibleColumns());\n        taskSetCatalogStamp.refresh();\n    }\n\n    private static final Map<Integer, Set<String>> VisibleColumns = new HashMap<>() {{\n        /* all tasks */put(22, Set.of(\"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"madeBy\", \"process\", \"createDate\", \"dueDate\", \"adviseDate\", \"madeDate\", \"state\", \"repeated\", \"daysLeft\"));\n        /* my tasks */put(24, Set.of(\"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"process\", \"createDate\", \"dueDate\", \"adviseDate\", \"state\", \"repeated\", \"daysLeft\"));\n        /* processes */put(25, Set.of(\"name\", \"reference\", \"relatedObject\", \"createdBy\", \"createDate\", \"state\"));\n        /* wait tasks */put(26, Set.of(\"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"process\", \"createDate\", \"dueDate\", \"adviseDate\", \"state\", \"repeated\", \"daysLeft\"));\n        /* signatures */put(31, Set.of(\"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"createDate\", \"dueDate\", \"adviseDate\", \"state\", \"repeated\", \"daysLeft\"));\n    }};\n    private Set<String> visibleColumns() {\n        return VisibleColumns.get(taskSet.getERC());\n    }\n\n    private void showTasksBlock() {\n        taskSetBlock.show();\n        taskBlock.hide();\n    }\n\n    private void showTaskBlock() {\n        taskSetBlock.hide();\n        taskBlock.show();\n    }\n\n    private void open(TGTask item) {\n        this.selectedTask = item;\n        showTaskBlock();\n    }\n\n    private void refreshTaskBlock() {\n        taskBlock.taskStamp.backInfo(label, path -> path.replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", \"Tareas\").replace(\":location\", StringUtil.encode(taskSetName)), null);\n        taskBlock.taskStamp.onGotoTask(this::open);\n        taskBlock.taskStamp.room(room);\n        taskBlock.taskStamp.task(selectedTask);\n        taskBlock.taskStamp.refresh();\n    }\n\n}")));
    }
}

