/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.definition.base;

import io.intino.goros.egeasy.m3.attribute.Attributes;
import io.intino.goros.egeasy.m3.definition.base.DefinitionException;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtension;
import io.intino.goros.egeasy.m3.definition.base.ListDefInstances;
import io.intino.goros.egeasy.m3.definition.base.ListDefinitions;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import java.util.List;

public abstract class Definition {
    public static final int NULL_DRC = 0;
    public static final int NULL_TYPE_VALUE = 0;
    private String name;
    private String caption;
    private int DRC;
    private int typeValue;
    private String icon;
    private String iconIndex;
    private Definition root;
    private Definition parent;
    private ListDefinitions children;
    private ListDefInstances definitions;
    private Attributes attributes;
    private DefinitionExtension extension;

    public Definition() {
        this(null, 0, 0);
    }

    public Definition(String name, int drc, int typeValue) {
        this.name = name;
        this.DRC = drc;
        this.typeValue = typeValue;
        this.attributes = new Attributes();
        this.children = new ListDefinitions();
        this.definitions = new ListDefInstances();
    }

    public void extend(Class classExtension) throws DefinitionException {
        try {
            this.extension = (DefinitionExtension)classExtension.newInstance();
        }
        catch (Exception e) {
            throw new DefinitionException("Can't create extension", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaption() {
        String result = LibraryDefinitions.getAtLabel(this);
        return result != null ? result : this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public int getDRC() {
        return this.DRC;
    }

    public void setDRC(int drc) {
        this.DRC = drc;
    }

    public int getTypeValue() {
        return this.typeValue;
    }

    public void setTypeValue(int typeValue) {
        this.typeValue = typeValue;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIconIndex() {
        return this.iconIndex;
    }

    public void setIconIndex(String iconIndex) {
        this.iconIndex = iconIndex;
    }

    public Definition getRoot() {
        return this.root;
    }

    public void setRoot(Definition root) {
        this.root = root;
    }

    public Definition getParent() {
        return this.parent;
    }

    public void setParent(Definition parent) {
        if (this.parent != null) {
            this.parent.getChildren().remove(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.typeValue = this.parent.typeValue;
            this.parent.getChildren().add(this);
            if (this.parent.root == null) {
                this.setRoot(this.parent);
            } else {
                this.setRoot(this.parent.root);
            }
        }
    }

    public ListDefinitions getChildren() {
        return this.children;
    }

    public ListDefInstances getDefinitions() {
        return this.definitions;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public DefinitionExtension getExtension() {
        return this.extension;
    }

    public boolean isVisible() {
        List<String> attribute = this.getAttributes().findAttribute("VISIBLE");
        if (attribute.isEmpty()) {
            return true;
        }
        if (this.root == Metamodel.getInstance().DTDocument) {
            return true;
        }
        String value = attribute.stream().findFirst().orElse(null);
        if (value == null) {
            return true;
        }
        return !value.equalsIgnoreCase("falso");
    }

    public int order() {
        List<String> attribute = this.getAttributes().findAttribute("ORDEN");
        if (attribute.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(attribute.stream().findFirst().orElse(null));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Definition [");
        stringBuilder.append("name=" + this.name).append(", caption=" + this.caption).append(", drc=" + this.DRC).append(", typeValue=" + this.typeValue);
        if (this.icon != null) {
            stringBuilder.append(", icon=" + this.icon);
        }
        if (this.iconIndex != null) {
            stringBuilder.append(", iconIndex=" + this.iconIndex);
        }
        if (this.attributes.size() > 0) {
            stringBuilder.append(", atrributes=" + this.attributes.getContent());
        }
        if (this.root != null) {
            stringBuilder.append(", rootDRC=" + this.root.getDRC());
        }
        if (this.parent != null) {
            stringBuilder.append(", parentDRC=" + this.parent.getDRC());
        }
        if (this.extension != null) {
            stringBuilder.append(", extension=" + this.extension);
        }
        if (this.definitions.size() > 0) {
            stringBuilder.append(", definitions=" + this.definitions);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

