/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.util;

import io.intino.goros.modernizing.egeasy.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final Integer BUFFER_SIZE = 8192;

    public static Boolean compress(ArrayList<String> aFiles, String sDestinationFilename) {
        BufferedInputStream oOrigin = null;
        try {
            FileOutputStream oDestination = new FileOutputStream(sDestinationFilename);
            ZipOutputStream oOutput = new ZipOutputStream(new BufferedOutputStream(oDestination));
            byte[] aData = new byte[BUFFER_SIZE.intValue()];
            for (String sFilename : aFiles) {
                int iCount;
                FileInputStream fisInput = new FileInputStream(sFilename);
                oOrigin = new BufferedInputStream(fisInput, BUFFER_SIZE);
                ZipEntry oEntry = new ZipEntry(sFilename);
                oOutput.putNextEntry(oEntry);
                while ((iCount = oOrigin.read(aData, 0, BUFFER_SIZE)) != -1) {
                    oOutput.write(aData, 0, iCount);
                }
                oOrigin.close();
            }
            oOutput.close();
            return true;
        }
        catch (Exception var11) {
            return false;
        }
    }

    public static Boolean decompress(String sFilename, String sDestination) {
        return ZipUtil.decompress(new File(sFilename), sDestination);
    }

    public static Boolean decompress(InputStream inputStream, String destination) {
        try {
            ZipEntry oEntry;
            BufferedOutputStream output = null;
            ZipInputStream input = new ZipInputStream(new BufferedInputStream(inputStream));
            byte[] aData = new byte[BUFFER_SIZE.intValue()];
            while ((oEntry = input.getNextEntry()) != null) {
                int iCount;
                if (oEntry.isDirectory()) {
                    new File(destination + File.separator + oEntry.getName()).mkdirs();
                    continue;
                }
                String sDestDN = FileUtil.getDirname(destination + File.separator + oEntry.getName());
                String sDestFN = destination + File.separator + oEntry.getName();
                new File(sDestDN).mkdirs();
                FileOutputStream oOutput = new FileOutputStream(sDestFN);
                output = new BufferedOutputStream(oOutput, BUFFER_SIZE);
                while ((iCount = input.read(aData, 0, BUFFER_SIZE)) != -1) {
                    output.write(aData, 0, iCount);
                }
                output.flush();
                output.close();
            }
            input.close();
            return true;
        }
        catch (Exception var11) {
            return false;
        }
    }

    public static Boolean decompress(File oFile, String sDestination) {
        try {
            return ZipUtil.decompress(new FileInputStream(oFile), sDestination);
        }
        catch (Exception var11) {
            return false;
        }
    }
}

