/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.util;

import io.intino.goros.egeasy.m3.definition.base.DefType;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionContent;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionLocation;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DefinitionUtils {
    public static String basePackage(TreeNodeResource dictionary) {
        String basePackage = null;
        for (Definition d : dictionary.getDefinitions()) {
            String name = d.getName();
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            if (basePackage == null) {
                basePackage = name;
                continue;
            }
            basePackage = StringUtil.greatestCommonPrefix(basePackage, name);
        }
        return basePackage;
    }

    private static boolean isLocation(Definition definition) {
        return definition.getExtension() instanceof DefinitionExtensionLocation;
    }

    private static boolean isEntitySetDefinition(Definition definition) {
        return io.intino.goros.egeasy.m3.utils.DefinitionUtils.isCollectionDefinition(definition) != false || io.intino.goros.egeasy.m3.utils.DefinitionUtils.isCatalogDefinition(definition) != false;
    }

    private static boolean checkDefContained(Definition defContained) {
        if (!(defContained instanceof DefType)) {
            return false;
        }
        if (((DefType)defContained).getAbstract()) {
            return false;
        }
        return io.intino.goros.egeasy.m3.utils.DefinitionUtils.isContainerDefinition(defContained);
    }

    private static void fillDefContainersContained(Definition defContained, List<Definition> listDefContainer) {
        if (DefinitionUtils.checkDefContained(defContained)) {
            listDefContainer.add(defContained);
        }
        for (Definition defchildren : defContained.getChildren()) {
            DefinitionUtils.fillDefContainersContained(defchildren, listDefContainer);
        }
    }

    private static List<Definition> getListDefContainersContained(Definition defContained) {
        if (!(defContained instanceof DefType)) {
            return null;
        }
        ArrayList<Definition> listDefContainer = new ArrayList<Definition>();
        DefinitionUtils.fillDefContainersContained(defContained, listDefContainer);
        return listDefContainer;
    }

    public static void fillDefContent(Definition definition, List<Definition> listDefContent) {
        if (definition.getExtension() instanceof DefinitionExtensionContent) {
            Definition defContained = ((DefinitionExtensionContent)definition.getExtension()).getDefinitionContained();
            List<Definition> listDefContained = DefinitionUtils.getListDefContainersContained(defContained);
            if (listDefContained != null) {
                listDefContent.addAll(listDefContained);
            }
        } else {
            for (Definition def : definition.getDefinitions()) {
                DefinitionUtils.fillDefContent(def, listDefContent);
            }
        }
    }

    private static void addDefinition(List<Definition> listDefEntitySet, Definition definition) {
        if (listDefEntitySet.contains(definition)) {
            return;
        }
        listDefEntitySet.add(definition);
        if (io.intino.goros.egeasy.m3.utils.DefinitionUtils.isCollectionDefinition(definition).booleanValue()) {
            ArrayList<Definition> listDefContent = new ArrayList<Definition>();
            DefinitionUtils.fillDefContent(definition, listDefContent);
            for (Definition defContainer : listDefContent) {
                DefinitionUtils.fillEntitySetDefinition(listDefEntitySet, defContainer);
            }
        }
    }

    private static void addDefinition(List<Definition> listDefEntitySet, List<Definition> listDefinitions) {
        for (Definition definition : listDefinitions) {
            DefinitionUtils.addDefinition(listDefEntitySet, definition);
        }
    }

    private static void fillEntitySetDefinition(List<Definition> listDefEntitySet, Definition definition) {
        if (DefinitionUtils.isEntitySetDefinition(definition)) {
            DefinitionUtils.addDefinition(listDefEntitySet, definition);
            return;
        }
        List<Definition> listEntitySetDefinition = definition.getDefinitions().stream().filter(DefinitionUtils::isEntitySetDefinition).collect(Collectors.toList());
        DefinitionUtils.addDefinition(listDefEntitySet, listEntitySetDefinition);
        for (Definition defChildren : definition.getChildren()) {
            DefinitionUtils.fillEntitySetDefinition(listDefEntitySet, defChildren);
        }
    }

    public static List<Definition> entitySetDefinitions(Definition roomDefinition) {
        if (!io.intino.goros.egeasy.m3.utils.DefinitionUtils.isRoomDefinition(roomDefinition).booleanValue()) {
            return null;
        }
        ArrayList<Definition> listDefEntitySet = new ArrayList<Definition>();
        List defLocations = roomDefinition.getDefinitions().stream().filter(DefinitionUtils::isLocation).collect(Collectors.toList());
        for (Definition defLocation : defLocations) {
            DefinitionUtils.fillEntitySetDefinition(listDefEntitySet, ((DefinitionExtensionLocation)defLocation.getExtension()).getDefinitionLocated());
        }
        return listDefEntitySet;
    }
}

