/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class RoomTemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.type("room"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.Display;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\n\nimport io.intino.goros.egeasy.box.ProviderHelper;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.RoomSectionContainer;\nimport io.intino.goros.egeasy.box.ui.RoomLocationContainer;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.ui.model.Location;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates.TaskSetTemplate;\n\nimport java.util.function.Consumer;\n\npublic class ")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template extends Abstract")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> implements RoomSectionContainer {\n    private Section selectedSection;\n    private BlockConditional current = null;\n    private static final int drc = ")).output(this.mark("drc", new String[0])).output(this.literal(";\n\n    public ")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void back() {\n        current.children(RoomLocationContainer.class).forEach(c -> ((RoomLocationContainer)c).back());\n    }\n\n    @Override\n    public boolean checkDirty(Consumer<Boolean> saveListener) {\n        return current.children(RoomLocationContainer.class).stream().anyMatch(c -> ((RoomLocationContainer)c).checkDirty(saveListener));\n    }\n\n    @Override\n    public void open(Section section, Location location) {\n        if (current != null) current.hide();\n        String findValue = DisplayHelper.normalize(section.label() + location.name()).toLowerCase();\n\n        Display displayFound = null;\n        for (Display display: children()) {\n            String name = DisplayHelper.normalize(section.label() + display.name()).toLowerCase();\n            if (name.equals(findValue)) displayFound = display;\n        }\n        current = (BlockConditional) children().stream().filter(c -> c.name().toLowerCase().equals(findValue)).findFirst().orElse(null);\n        if ((displayFound != null) && (current == null))\n            current = (BlockConditional) displayFound;\n\n        notFound.visible(current == null);\n        selectedSection = section;\n        DisplayHelper.showAndRefresh(current);\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    @Override\n    public void open(Section section, Location location, int drc, int rrc) {\n        if (current == null) return;\n        current.children(RoomLocationContainer.class).forEach(c -> ((RoomLocationContainer)c).open(drc, rrc));\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        locales.onShow(e -> refreshTaskSet(22, \"locales\", \"Tareas locales\", locales.localesStamp));\n        misTareas.onShow(e -> refreshTaskSet(24, \"mis-tareas\", \"Mis tareas\", misTareas.misTareasStamp));\n        procesos.onShow(e -> refreshTaskSet(25, \"procesos\", \"Procesos\", procesos.procesosStamp));\n        espera.onShow(e -> refreshTaskSet(26, \"espera\", \"Tareas en espera\", espera.esperaStamp));\n        firma.onShow(e -> refreshTaskSet(31, \"firma\", \"Tareas de firma\", firma.firmaStamp));\n        ")).output(this.mark("section", "init").multiple("\n")).output(this.literal("\n    }\n\n    private void refreshTaskSet(int rrc, String name, String label, TaskSetTemplate display) {\n        TGRoom room = ProviderHelper.room(drc, box().provider(session()));\n        display.label(label);\n        display.rrc(rrc);\n        display.room(room, \"")).output(this.mark("name", "firstLowerCase")).output(this.literal("\");\n        display.taskSet(taskSet(rrc, room), name);\n    }\n\n    private TGTaskSet taskSet(int rrc, TGRoom room) {\n        if (room == null) return null;\n        if (rrc == 22) return room.getAllTasks();\n        if (rrc == 24) return room.getMyTasks();\n        if (rrc == 25) return room.getProcesses();\n        if (rrc == 26) return room.getWaitTasks();\n        if (rrc == 31) return room.getMySignatures();\n        return null;\n    }\n\n    private void refreshLocation(int locationDRC, String locationName) {\n        RoomLocationContainer locationContainer = container(locationDRC);\n        if (locationContainer == null) return;\n        TGRoom room = ProviderHelper.room(drc, box().provider(session()));\n        locationContainer.room(room, \"")).output(this.mark("name", "firstLowerCase")).output(this.literal("\");\n        locationContainer.section(selectedSection);\n        locationContainer.location(ProviderHelper.location(room, locationDRC), locationName);\n    }\n\n    private RoomLocationContainer container(int locationDRC) {\n        ")).output(this.mark("section", "stamp").multiple("\n")).output(this.literal("\n        return null;\n    }\n\n}")), this.rule().condition(this.type("section"), this.trigger("init")).output(this.mark("location", "init").multiple("\n")), this.rule().condition(this.type("location"), this.trigger("init")).output(this.mark("name", "firstLowerCase")).output(this.literal(".onShow(e -> refreshLocation(")).output(this.mark("drc", new String[0])).output(this.literal(", \"")).output(this.mark("name", "firstUpperCase")).output(this.literal("\"));")), this.rule().condition(this.type("section"), this.trigger("stamp")).output(this.mark("location", "stamp").multiple("\n")), this.rule().condition(this.type("location"), this.trigger("stamp")).output(this.literal("if (locationDRC == ")).output(this.mark("drc", new String[0])).output(this.literal(") return ")).output(this.mark("name", "firstLowerCase")).output(this.literal(".")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp;")));
    }
}

