/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class LocationTemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.type("location"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;\nimport io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.alexandria.ui.spark.UIFile;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.DatasourceHelper;\nimport io.intino.goros.egeasy.box.ui.RoomLocationContainer;\nimport io.intino.goros.egeasy.box.ui.datasources.")).output(this.mark("Mock", new String[0])).output(this.literal("EntitySetDatasource;\nimport io.intino.goros.egeasy.box.ui.datasources.EntitySetGridDatasource;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.component.TGComponent;\nimport io.intino.goros.egeasy.m3.entity.component.TGEntitySet;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.room.TGLocation;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n")).output(this.expression(new Rule.Output[0]).output(this.mark("grid", "import"))).output(this.literal("\n\nimport java.util.HashMap;\nimport java.util.List;\nimport java.io.ByteArrayInputStream;\nimport java.util.Collections;\nimport java.util.Map;\nimport java.util.function.Consumer;\n\npublic class ")).output(this.mark("placeName", "firstUpperCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template extends Abstract")).output(this.mark("placeName", "firstUpperCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> implements RoomLocationContainer {\n    private TGRoom room;\n    private String roomName;\n    private Section section;\n    private TGLocation location;\n    private String locationName;\n    private EntitySetItem selectedEntity;\n    private boolean selectedEntityReadonly = true;\n    private boolean readonly = true;\n\n    public ")).output(this.mark("placeName", "firstUpperCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public void room(TGRoom room, String name) {\n        this.room = room;\n        this.roomName = name;\n        searchBox.condition(null);\n    }\n\n    public void section(Section section) {\n        this.section = section;\n    }\n\n    public void location(TGLocation location, String name) {\n        this.location = location;\n        this.locationName = name;\n        TGIdentifier resourceIdentifier = location.getResource();\n        TGResource resource = box().provider(session()).openResource(resourceIdentifier.getERC(), resourceIdentifier.getDRC());\n        TGComponent entitySet = resource.getComponents().getAComponents().stream().filter(c -> c instanceof TGEntitySet).findFirst().orElse(null);\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.source(new ")).output(this.mark("Mock", new String[0])).output(this.literal("EntitySetGridDatasource(box().provider(session()), session(), resource, (TGEntitySet)entitySet));\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        initToolbar();\n        initGrid();\n        entitiesBlock.onShow(e -> refreshEntitiesBlock());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        TGIdentifier resourceIdentifier = location.getResource();\n        TGResource resource = box().provider(session()).openResource(resourceIdentifier.getERC(), resourceIdentifier.getDRC());\n        TGComponent entitySet = resource.getComponents().getAComponents().stream().filter(c -> c instanceof TGEntitySet).findFirst().orElse(null);\n        icon.value(")).output(this.mark("icon", new String[0])).output(this.literal(");\n        refreshToolbar();\n        showCatalogBlock();\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.selection(java.util.Collections.emptyList());\n        //")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.allowMultiSelection(true); //!readonly\n        refreshCount(")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.itemCount());\n        refreshFilters(resource, entitySet);\n        refreshExport(resource, entitySet);\n    }\n\n    @Override\n    public void back() {\n        showCatalogBlock();\n    }\n\n    @Override\n    public boolean checkDirty(Consumer<Boolean> saveListener) {\n        if (!entitiesBlock.isVisible()) return true;\n        if (!entitiesBlock.entitiesStamp.dirty()) return true;\n        entitiesBlock.entitiesStamp.openSaveDialog(e -> saveListener.accept(true));\n        return false;\n    }\n\n    @Override\n    public void open(int drc, int rrc) {\n        selectedEntityReadonly = !box().provider(session()).isEditingResource(rrc);\n        open(EntitySetDatasource.itemOf(box().provider(session()).openResource(rrc, drc)));\n    }\n\n    private void refreshToolbar() {\n        refresh.visible(readonly);\n        edit.title(readonly ? \"Editar\" : \"Finalizar edici\u00f3n\");\n        edit.highlight(readonly ? io.intino.alexandria.ui.displays.components.Actionable.Highlight.Outline : io.intino.alexandria.ui.displays.components.Actionable.Highlight.Fill);\n        add.visible(")).output(this.mark("add", "readonly")).output(this.literal(");\n        deleteSelection.visible(true);//!readonly\n    }\n\n    private void initToolbar() {\n        edit.onExecute(e -> toggleEdition());\n        add.onExecute(e -> {\n            ")).output(this.mark("add", new String[0])).output(this.literal("\n            ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.reload();\n        });")).output(this.expression(new Rule.Output[0]).output(this.literal("\n")).output(this.literal("        run.onExecute(e -> {")).output(this.literal("\n")).output(this.literal("            ")).output(this.mark("run", new String[0])).output(this.literal("\n")).output(this.literal("        });")).output(this.literal("\n")).output(this.literal("        "))).output(this.literal("\n        refresh.onExecute(e -> ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.reload());\n        deleteSelection.onExecute(e -> delete(e.selection()));\n        initFilters();\n        initExport();\n    }\n\n    private void initFilters() {\n        filterListEditor.onAdd(this::addFilter);\n        filterListEditor.onRemove(this::removeFilter);\n        filterListEditor.onFilter(this::applyFilter);\n    }\n\n    private void initExport() {\n        exportWizard.filename(\"")).output(this.mark("label", new String[0])).output(this.literal(" \" + DisplayHelper.downloadDate());\n        exportWizard.onExportFile(mode -> box().provider(session()).exportResourceFiles(DisplayHelper.entitiesIdentifiersOf(")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.selectedItems()).toArray(new TGIdentifier[0])));\n        exportWizard.onExportSet(mode -> ((EntitySetGridDatasource)")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.source()).export(mode));\n    }\n\n    private void refreshFilters(TGResource resource, TGComponent entitySet) {\n        filterListEditor.columns(")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.columns());\n        filterListEditor.filters(DatasourceHelper.filters(box().provider(session()), resource, entitySet));\n        filterListEditor.refresh();\n    }\n\n    private void refreshExport(TGResource resource, TGComponent entitySet) {\n        exportWizard.mode(ExportWizard.Mode.Set);\n        exportWizard.entity(entitySet);\n        exportWizard.refresh();\n    }\n\n    private void addFilter(SetFilter filter) {\n        TGIdentifier resourceIdentifier = location.getResource();\n        TGResource resource = box().provider(session()).openResource(resourceIdentifier.getERC(), resourceIdentifier.getDRC());\n        TGComponent entitySet = resource.getComponents().getAComponents().stream().filter(c -> c instanceof TGEntitySet).findFirst().orElse(null);\n        if (entitySet == null) return;\n        box().provider(session()).saveFilter(resource.getERC(), entitySet.getDRC(), filter.title(), filter.expression());\n    }\n\n    private void removeFilter(SetFilter filter) {\n        TGIdentifier resourceIdentifier = location.getResource();\n        TGResource resource = box().provider(session()).openResource(resourceIdentifier.getERC(), resourceIdentifier.getDRC());\n        TGComponent entitySet = resource.getComponents().getAComponents().stream().filter(c -> c instanceof TGEntitySet).findFirst().orElse(null);\n        if (entitySet == null) return;\n        box().provider(session()).removeFilter(resource.getERC(), entitySet.getDRC(), filter.title());\n    }\n\n    private void applyFilter(SetFilter filter) {\n        if (filter != null) ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.filter(\"filter\", Collections.singletonList(filter.expression()));\n        else ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.removeFilter(\"filter\");\n    }\n\n    private void delete(java.util.List<EntitySetItem> selection) {\n        final List<String> withFailureList = new java.util.ArrayList<>();\n        notifyUser(\"Eliminando elementos seleccionados...\", UserMessage.Type.Loading);\n        selection.forEach(e -> {\n            io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult result = box().provider(session()).deleteResource(e.rrc(), e.drc());\n            if (!result.success()) withFailureList.add(e.rrc() + \" - \" + e.name() + \" (\" + result.getMessage() + \")\");\n        });\n        String message = !withFailureList.isEmpty() ? String.join(\", \", withFailureList) : \"\";\n        if (!message.isEmpty()) notifyUser(\"Los siguientes elementos no pudieron eliminarse: \" + message, UserMessage.Type.Error);\n        else notifyUser(\"Elementos eliminados\", UserMessage.Type.Success);\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.reload();\n    }\n\n    private void initGrid() {\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.onSelect(e -> exportWizard.mode(e.selection().isEmpty() ? ExportWizard.Mode.Set : ExportWizard.Mode.File));\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.onSortColumn(event -> {\n            GridColumn<EntitySetItem> column = event.column();\n            SortColumnEvent.Mode mode = event.mode();\n            ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.sortings(mode != SortColumnEvent.Mode.None ? List.of(column.label() + \"=\" + (mode == SortColumnEvent.Mode.Ascendant ? \"A\" : \"D\")) : Collections.emptyList());\n        });\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.itemResolver(new Grid.ItemResolver<>() {\n            @Override\n            public GridItem build(EntitySetItem entity) {\n                GridItem result = new GridItem();\n                ")).output(this.mark("set", "itemResolver")).output(this.literal("\n                return result;\n            }\n\n            @Override\n            public String address(GridColumn<EntitySetItem> column, EntitySetItem entity) {\n                if (column.type() != GridColumn.Type.Link) return null;\n                if (column.address() == null) return null;\n                return session().browser().basePath() + column.address().replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", StringUtil.encode(section.label().toLowerCase())).replace(\":location\", StringUtil.encode(locationName.toLowerCase())).replace(\":drc\", String.valueOf(entity.drc())).replace(\":rrc\", String.valueOf(entity.rrc()));\n            }\n        });\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.onRefreshItemCount(this::refreshCount);\n    }\n\n    private void toggleEdition() {\n        readonly = !readonly;\n        ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.selection(java.util.Collections.emptyList());\n        //")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.allowMultiSelection(true); //!readonly\n        refreshToolbar();\n    }\n\n    private void refreshCount(RefreshCountEvent event) {\n        refreshCount(event.count());\n    }\n\n    private void refreshCount(long count) {\n        this.count.value(DisplayHelper.countMessage(count, \"elemento\", \"elementos\"));\n    }\n\n    private void open(EntitySetItem entity) {\n        selectedEntity = entity;\n        showEntitiesBlock();\n    }\n\n    private void refreshEntitiesBlock() {\n        entitiesBlock.entitiesStamp.onRemove(e -> {\n            showCatalogBlock();\n            ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("name", "firstUpperCase")).output(this.literal("Grid.reload();\n        });\n        entitiesBlock.entitiesStamp.backInfo(\"")).output(this.mark("label", new String[0])).output(this.literal("\", path -> path.replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", StringUtil.encode(section.label().toLowerCase())).replace(\":location\", StringUtil.encode(locationName.toLowerCase())), null);\n        entitiesBlock.entitiesStamp.room(room);\n        entitiesBlock.entitiesStamp.entity(selectedEntity);\n        entitiesBlock.entitiesStamp.readonly(selectedEntityReadonly);\n        entitiesBlock.entitiesStamp.refresh();\n    }\n\n    private void showCatalogBlock() {\n        catalogBlock.show();\n        entitiesBlock.hide();\n    }\n\n    private void showEntitiesBlock() {\n        catalogBlock.hide();\n        entitiesBlock.show();\n    }\n}")), this.rule().condition(this.type("set"), this.trigger("itemresolver")).output(this.mark("column", "itemResolver").multiple("\n")), this.rule().condition(this.allTypes("column", "link"), this.trigger("itemresolver")).output(this.literal("result.add(entity.value(\"")).output(this.mark("label", new String[0])).output(this.literal("\").asString() != null ? entity.value(\"")).output(this.mark("label", new String[0])).output(this.literal("\").asString() : \"Sin nombre\");")), this.rule().condition(this.type("column"), this.trigger("itemresolver")).output(this.literal("result.add(entity.value(\"")).output(this.mark("label", new String[0])).output(this.literal("\").")).output(this.mark("columnType", new String[0])).output(this.literal("());")), this.rule().condition(this.allTypes("icon", "defined"), new Rule.Condition[0]).output(this.literal("io.intino.goros.egeasy.box.ui.DisplayHelper.iconUrlOf(box().egeConfiguration().iconsDir() + \"/")).output(this.mark("icon", new String[0])).output(this.literal(".ico\")")), this.rule().condition(this.type("icon"), new Rule.Condition[0]).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.model.Model.class.getResource(\"/icons/")).output(this.mark("icon", new String[0])).output(this.literal(".ico\")")), this.rule().condition(this.allTypes("columnType", "date"), new Rule.Condition[0]).output(this.literal("asInstant")), this.rule().condition(this.allTypes("columnType", "integer"), new Rule.Condition[0]).output(this.literal("asNumber")), this.rule().condition(this.type("columnType"), new Rule.Condition[0]).output(this.literal("asString")), this.rule().condition(this.allTypes("add", "empty"), this.trigger("readonly")).output(this.literal("false")), this.rule().condition(this.type("add"), this.trigger("readonly")).output(this.literal("readonly")), this.rule().condition(this.allTypes("add", "multiple"), new Rule.Condition[0]).output(this.literal("String option = e.option();\nif (location == null) return;\nTGComponent entitySet = DisplayHelper.entitySetOf(location, box().provider(session()));\nif (entitySet == null) {\n    notifyUser(\"No se ha podido a\u00f1adir el elemento\", UserMessage.Type.Error);\n    return;\n}\n")).output(this.mark("addOption", "multiple").multiple("\n")).output(this.literal("\nselectedEntityReadonly = false;\nopen(selectedEntity);")), this.rule().condition(this.type("add"), new Rule.Condition[0]).output(this.literal("if (location == null) return;\nTGComponent entitySet = DisplayHelper.entitySetOf(location, box().provider(session()));\nif (entitySet == null) {\n    notifyUser(\"No se ha podido a\u00f1adir el elemento\", UserMessage.Type.Error);\n    return;\n}\n")).output(this.mark("addOption", new String[0]).multiple("\n")).output(this.literal("\nselectedEntityReadonly = false;\nopen(selectedEntity);")), this.rule().condition(this.type("addOption"), this.trigger("multiple")).output(this.literal("if (option.equals(\"A\u00f1adir ")).output(this.mark("label", new String[0])).output(this.literal("\")) selectedEntity = ")).output(this.mark("Mock", new String[0])).output(this.literal("EntitySetDatasource.itemOf(box().provider(session()).createResource(")).output(this.mark("drc", new String[0])).output(this.literal(", entitySet.getIdentifier()));")), this.rule().condition(this.type("addOption"), new Rule.Condition[0]).output(this.literal("selectedEntity = ")).output(this.mark("Mock", new String[0])).output(this.literal("EntitySetDatasource.itemOf(box().provider(session()).createResource(")).output(this.mark("drc", new String[0])).output(this.literal(", entitySet.getIdentifier()));")), this.rule().condition(this.allTypes("run", "multiple"), new Rule.Condition[0]).output(this.literal("String option = e.option();\nint drc = -1;\n")).output(this.mark("runOption", "multiple").multiple("\n")).output(this.literal("\nif (drc == -1) {\n    notifyUser(\"No se ha podido ejecutar la operaci\u00f3n\", UserMessage.Type.Error);\n    return;\n}\nsoul().display(RoomTemplate.class).addProcess(option, drc, location.getResource().getERC(), e1 -> ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("parent", "firstUpperCase")).output(this.literal("Grid.reload());")), this.rule().condition(this.type("run"), new Rule.Condition[0]).output(this.mark("runOption", new String[0]).multiple("\n")), this.rule().condition(this.type("runOption"), this.trigger("multiple")).output(this.literal("if (option.equals(\"")).output(this.mark("label", new String[0])).output(this.literal("\")) drc = ")).output(this.mark("drc", new String[0])).output(this.literal(";")), this.rule().condition(this.type("runOption"), new Rule.Condition[0]).output(this.literal("soul().display(RoomTemplate.class).addProcess(\"")).output(this.mark("label", new String[0])).output(this.literal("\", ")).output(this.mark("drc", new String[0])).output(this.literal(", location.getResource().getERC(), e1 -> ")).output(this.mark("placeName", "firstLowerCase")).output(this.mark("parent", "firstUpperCase")).output(this.literal("Grid.reload());")));
    }
}

