/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ContainerTemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.type("definition"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.Component;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;\nimport io.intino.alexandria.ui.displays.components.addressable.Addressed;\nimport io.intino.alexandria.ui.displays.UserMessage;\n\nimport io.intino.goros.egeasy.box.ProviderHelper;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.DatasourceHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.EntitySetGridDatasource;\nimport io.intino.goros.egeasy.box.util.FileHelper;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.ui.EntitySetItemContainer;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.TGFieldError;\nimport io.intino.goros.egeasy.m3.definition.base.Definition;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.component.TGComponent;\nimport io.intino.goros.egeasy.m3.entity.component.TGForm;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.library.LibraryDocuments;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates.EntitiesTemplate;\n\nimport java.io.File;\nimport java.util.ArrayList;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\nimport java.util.HashMap;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Map;\n\npublic class ")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template extends Abstract")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> implements EntitySetItemContainer {\n    private TGRoom room;\n    private EntitySetItem entity;\n    private TGResource selectedResource;\n    private Consumer<Boolean> showListener;\n    private Consumer<Boolean> finishEditionListener;\n    private String backTitle;\n    private Function<String, String> backAddressResolver;\n    private Consumer<EntitySetItem> backListener;\n    private Consumer<EntitySetItem> removeListener;\n    private String selectedView;\n    private boolean readonly = true;\n    private ValidateResult validateResult;\n    ")).output(this.expression(new Rule.Output[0]).output(this.mark("content", "declaration"))).output(this.literal("\n\n    public ")).output(this.mark("name", "firstUpperCase")).output(this.literal("Template(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void room(TGRoom room) {\n        this.room = room;\n    }\n\n    @Override\n    public void entity(EntitySetItem entity) {\n        this.entity = entity;\n        validateResult = null;\n        reset();\n    }\n\n    @Override\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void onShow(Consumer<Boolean> listener) {\n        this.showListener = listener;\n    }\n\n    @Override\n    public void backInfo(String title, Function<String, String> addressResolver, Consumer<EntitySetItem> listener) {\n        this.backTitle = title;\n        this.backAddressResolver = addressResolver;\n        this.backListener = listener;\n    }\n\n    @Override\n    public void onRemove(Consumer<EntitySetItem> listener) {\n        this.removeListener = listener;\n    }\n\n    ")).output(this.expression(new Rule.Output[0]).output(this.mark("content", new String[0]))).output(this.literal("\n}")), this.rule().condition(this.type("content"), this.trigger("declaration")).output(this.mark("view", "declaration").multiple("\n")), this.rule().condition(this.type("content"), new Rule.Condition[0]).output(this.literal("@Override\npublic void init() {\n    super.init();\n    linkDomain.onExecute(e -> {\n        if (!readonly) updateEdition(true);\n        if (backListener != null) backListener.accept(entity);\n    });\n    viewSelector.onSelect(e -> selectedView = e.selection().isEmpty() ? null : (String) e.selection().get(0));\n    entityLayerTrigger.onOpen(e -> fillLayer(e.layer()));\n    save.onExecute(e -> save());\n    remove.onExecute(e -> removeElement());\n    edit.onExecute(e -> updateEdition(false));\n    finishEdition.onExecute(e -> {\n        if (dirty()) {\n            finishEditionDialog.open();\n            return;\n        }\n        updateEdition(true);\n    });\n    finishEditionSelector.onSelect(e -> finishEdition());\n    addProcess.onExecute(e -> addProcess(e.option()));\n    validationResultBlock.onShow(e -> refreshValidationResult());\n    validationResultStamp.onSelect(this::focusValidationResultError);\n    ")).output(this.mark("view", "init").multiple("\n")).output(this.literal("\n    tareasBlock.onShow(e -> refreshTareasBlock());\n}\n\npublic boolean dirty() {\n    ")).output(this.mark("view", "dirtyCall").multiple("\n")).output(this.literal("\n    return false;\n}\n\npublic void openSaveDialog(Consumer<Boolean> listener) {\n    finishEditionListener = listener;\n    finishEditionDialog.open();\n}\n\n@Override\npublic void refresh() {\n    super.refresh();\n    TGContainer container = (TGContainer) box().provider(session()).openResource(entity.rrc(), entity.drc());\n    icon.value(")).output(this.mark("icon", new String[0])).output(this.literal(");\n    title.value(entity.label() != null ? entity.label() : \"Sin nombre\");\n    refreshDomain(container);\n    refreshState(container);\n    if (viewSelector.selection().isEmpty()) viewSelector.select(\"")).output(this.mark("defaultView", "firstLowerCase")).output(this.literal("\");\n    else if (selectedView != null) viewSelector.select(selectedView);\n}\n\nprivate void refreshDomain(TGContainer container) {\n    linkDomain.title(backTitle);\n    if (backAddressResolver != null) linkDomain.address(backAddressResolver);\n    if (backTitle != null) {\n        domain.visible(false);\n        return;\n    }\n    TGIdentifier identifier = box().provider(session()).createIdentifier(container.getDomainIdentifier().getERC());\n    domain.title(identifier != null ? identifier.getName() : null);\n    domain.visible(identifier != null);\n}\n\n")).output(this.mark("view", "initMethod").multiple("\n")).output(this.literal("\n")).output(this.mark("view", "refreshMethod").multiple("\n")).output(this.literal("\n")).output(this.mark("view", "focusMethod").multiple("\n")).output(this.literal("\n\npublic void refreshTareasBlock() {\n    TGResource container = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    tareasStamp.openMode(TaskSetCatalogTemplate.OpenMode.Layer);\n    tareasStamp.entity(container);\n    tareasStamp.taskSetName(\"tareas\");\n    tareasStamp.refresh();\n}\n\npublic boolean save() {\n    notifyUser(\"Guardando...\", io.intino.alexandria.ui.displays.UserMessage.Type.Loading);\n    ValidateResult result;\n    ")).output(this.mark("view", "saveCall").multiple("\n")).output(this.literal("\n    reset();\n    notifyUser(\"Se ha guardado correctamente\", io.intino.alexandria.ui.displays.UserMessage.Type.Success);\n    return true;\n}\n\nprivate void finishEdition() {\n    List<String> selection = finishEditionSelector.selection();\n    if (selection.isEmpty() || selection.get(0).equals(\"cancelOption\")) return;\n    if (selection.get(0).equals(\"saveOption\")) {\n        if (validateResult != null && !validateResult.getValidateError().getMessage().isEmpty()) {\n            notifyUser(\"Debe revisar los campos con error o advertencia\", UserMessage.Type.Error);\n            return;\n        }\n        save();\n    }\n    else reset();\n    updateEdition(true);\n}\n\nprivate void refreshState() {\n    refreshState((TGContainer) box().provider(session()).openResource(entity.rrc(), entity.drc()));\n}\n\nprivate void refreshState(TGContainer container) {\n    boolean editing = box().provider(session()).isEditingResource(entity.rrc());\n    edit.readonly(editing);\n    edit.visible(readonly);\n    finishEdition.visible(!readonly);\n    save.visible(!readonly);\n    remove.visible(readonly);\n    List<String> options = ProviderHelper.newProcessDefinitionsOptions(room, container);\n    addProcess.options(options);\n    addProcess.visible(readonly && !options.isEmpty());\n    remove.readonly(!io.intino.goros.egeasy.m3.library.LibraryResource.canDeleteResource(container));\n}\n\nprivate void reset() {\n    ")).output(this.mark("view", "resetCall").multiple("\n")).output(this.literal("\n}\n\nprivate void showValidationErrors(ValidateResult result) {\n    this.validateResult = result;\n    validationResultBlock.show();\n}\n\nprivate void refreshValidationResult() {\n    if (this.validateResult == null) return;\n    validationResultStamp.result(validateResult);\n    validationResultStamp.refresh();\n}\n\nprivate void focusValidationResultError(TGFieldError error) {\n    int drc = error.getDrc();\n    ")).output(this.mark("view", "focusCall").multiple("\n")).output(this.literal("\n}\n\nprivate void removeElement() {\n    io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult result = box().provider(session()).deleteResource(entity.rrc(), entity.drc());\n    if (!result.success()) {\n        notifyUser(result.getMessage(), UserMessage.Type.Error);\n        return;\n    }\n    notifyUser(\"Elemento eliminado\", UserMessage.Type.Success);\n    if (removeListener != null) removeListener.accept(entity);\n}\n\nprivate void open(TGResource resource) {\n    if (resource == null) return;\n    entityLayerTrigger.address(path -> path.replace(\":rrc\", String.valueOf(resource.getERC())).replace(\":drc\", String.valueOf(resource.getDRC())));\n    entityLayerTrigger.openLayer();\n}\n\nprivate void fillLayer(Layer<?, ?> layer) {\n    RoomTemplate template = new RoomTemplate(box());\n    template.readonly(true);\n    template.onRemove(e -> {\n        soul().currentLayer().close();\n        ")).output(this.mark("view", "refreshCall").multiple("\n")).output(this.literal("\n    });\n    layer.title(selectedResource.getIdentifier().getName());\n    layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n    layer.template(template);\n}\n\nprivate void updateEdition(boolean readonly) {\n    if (readonly) box().provider(session()).endEditionResource(entity.rrc());\n    else {\n        if (!box().provider(session()).isEditingResource(entity.rrc()) && !box().provider(session()).beginEditionResource(entity.rrc())) {\n            notifyUser(\"No se puede editar el elemento en estos momentos\", io.intino.alexandria.ui.displays.UserMessage.Type.Error);\n            return;\n        }\n    }\n    this.readonly = readonly;\n    refreshState();\n    if (finishEditionListener != null) {\n        finishEditionListener.accept(true);\n        finishEditionListener = null;\n    }\n    ")).output(this.mark("view", "refreshCall").multiple("\n")).output(this.literal("\n    validationResultBlock.hide();\n    validateResult = null;\n}\n\nprivate void addProcess(String option) {\n    Definition definition = ProviderHelper.newProcessDefinition(room, (TGContainer) box().provider(session()).openResource(entity.rrc(), entity.drc()), option);\n    if (definition == null) {\n        notifyUser(\"No se ha podido iniciar el proceso\", UserMessage.Type.Error);\n        return;\n    }\n    soul().display(RoomTemplate.class).addProcess(definition.getName(), definition.getDRC(), entity.rrc(), null);\n}\n")), this.rule().condition(this.allTypes("icon", "defined"), new Rule.Condition[0]).output(this.literal("io.intino.goros.egeasy.box.ui.DisplayHelper.iconUrlOf(box().egeConfiguration().iconsDir() + \"/")).output(this.mark("icon", new String[0])).output(this.literal(".ico\")")), this.rule().condition(this.type("icon"), new Rule.Condition[0]).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.model.Model.class.getResource(\"/icons/")).output(this.mark("icon", new String[0])).output(this.literal(".ico\")")), this.rule().condition(this.type("view"), this.trigger("declaration")).output(this.mark("declarationJavaContent", new String[0])), this.rule().condition(this.type("view"), this.trigger("init")).output(this.mark("name", "firstLowerCase")).output(this.literal("Block.onInit(e -> init")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block());\n")).output(this.mark("name", "firstLowerCase")).output(this.literal("Block.onShow(e -> refresh")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block());")), this.rule().condition(this.type("view"), this.trigger("initmethod")).output(this.literal("public void init")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block() {\n    ")).output(this.mark("initJavaContent", new String[0])).output(this.literal("\n}")), this.rule().condition(this.allTypes("view", "form"), this.trigger("refreshmethod")).output(this.literal("public void refresh")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block() {\n    if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Source != null && ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Source.dirty()) return;\n    ")).output(this.mark("refreshJavaContent", new String[0])).output(this.literal("\n}")), this.rule().condition(this.type("view"), this.trigger("refreshmethod")).output(this.literal("public void refresh")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block() {\n    ")).output(this.mark("refreshJavaContent", new String[0])).output(this.literal("\n}")), this.rule().condition(this.allTypes("view", "form"), this.trigger("focusmethod")).output(this.literal("public void focus")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block(int drc) {\n    ")).output(this.mark("focusJavaContent", new String[0])).output(this.literal("\n}")), this.rule().condition(this.type("view"), this.trigger("focusmethod")), this.rule().condition(this.type("view"), this.trigger("refreshcall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Block.isVisible()) refresh")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block();")), this.rule().condition(this.allTypes("view", "form"), this.trigger("focuscall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Block.isVisible()) focus")).output(this.mark("name", "firstUpperCase")).output(this.literal("Block(drc);")), this.rule().condition(this.type("view"), this.trigger("focuscall")), this.rule().condition(this.allTypes("view", "form"), this.trigger("dirtycall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Source.dirty()) return true;\n")).output(this.mark("dirtyJavaContent", new String[0])), this.rule().condition(this.type("view"), this.trigger("dirtycall")).output(this.mark("dirtyJavaContent", new String[0])), this.rule().condition(this.allTypes("view", "form"), this.trigger("resetcall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Source != null) ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Source.reset();\n")).output(this.mark("resetJavaContent", new String[0])), this.rule().condition(this.type("view"), this.trigger("resetcall")).output(this.mark("resetJavaContent", new String[0])), this.rule().condition(this.allTypes("view", "form"), this.trigger("savecall")).output(this.literal("result = ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Source.save();\nif (!result.success()) {\n    notifyUser(result.getMessage(), UserMessage.Type.Error);\n    return false;\n}\nif (!result.getValidateError().getMessage().isEmpty()) {\n    notifyUser(\"No se ha podido guardar\", UserMessage.Type.Error);\n    showValidationErrors(result);\n    return false;\n}")), this.rule().condition(this.allTypes("view", "document"), this.trigger("savecall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp != null) ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.save();")), this.rule().condition(this.type("view"), this.trigger("savecall")));
    }
}

