/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.xml.Node;
import io.intino.alexandria.xml.Xml;
import io.intino.goros.modernizing.egeasy.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NodeList;

public class Modernization {
    private Map<String, String> properties = new HashMap<String, String>();

    public File dictionary() {
        return new File(this.properties.getOrDefault("model", ""));
    }

    public boolean isMock() {
        return Boolean.parseBoolean(this.properties.getOrDefault("mock", "false"));
    }

    public String projectPackage() {
        return this.properties.getOrDefault("project.package", "");
    }

    public String projectPackageDirectory() {
        return this.projectPackage().replace(".", File.separator);
    }

    public String sourceDirectory() {
        return this.moduleDirectory() + File.separator + "src" + File.separator + this.projectPackageDirectory() + File.separator + this.moduleName();
    }

    public String sourceBoxDirectory() {
        return this.sourceDirectory() + File.separator + "box";
    }

    public String sourceGraphDirectory() {
        return this.sourceDirectory() + File.separator + "graph";
    }

    public String sourceRestDirectory() {
        return this.sourceBoxDirectory() + File.separator + "actions";
    }

    public String sourceUiDirectory() {
        return this.sourceBoxDirectory() + File.separator + "ui";
    }

    public String projectName() {
        return this.properties.getOrDefault("project.name", "");
    }

    public File projectDirectory() {
        return new File(this.properties.getOrDefault("project.directory", ""));
    }

    public String moduleName() {
        return this.properties.getOrDefault("module.name", "");
    }

    public List<String> rooms() {
        String rooms = this.properties.getOrDefault("rooms", null);
        return rooms != null ? Arrays.asList(rooms.split(",")) : null;
    }

    public String boxName() {
        String boxName = this.properties.getOrDefault("artifact.name", "");
        if (boxName.isEmpty()) {
            return this.moduleName();
        }
        return StringUtil.snakeCaseToCamelCase(boxName);
    }

    public File moduleDirectory() {
        return new File(this.projectDirectory() + File.separator + this.moduleName());
    }

    public List<String> excludedDefinitions() {
        String value = this.properties.getOrDefault("definitions.excluded", "");
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split(","));
    }

    private void put(String key, String value) {
        this.properties.put(key, value);
    }

    public static Modernization load(File file) {
        try {
            Modernization modernization = new Modernization();
            Xml xml = new Xml(new FileInputStream(file));
            Node root = xml.document().getChildNodes().get(0);
            org.w3c.dom.Node projectNode = root.child("project").get();
            org.w3c.dom.Node moduleNode = root.child("module").get();
            org.w3c.dom.Node artifactNode = root.child("artifact") != null ? root.child("artifact").get() : null;
            org.w3c.dom.Node roomsNode = root.child("rooms") != null ? root.child("rooms").get() : null;
            org.w3c.dom.Node definitionsNode = root.child("definitions") != null ? root.child("definitions").get() : null;
            modernization.put("mock", root.getAttributes().getNamedItem("mock") != null ? root.getAttributes().getNamedItem("mock").getTextContent() : "false");
            modernization.put("model", Modernization.absolutePathOf(file, root.child("model").get().getTextContent()));
            modernization.put("project.name", projectNode.getAttributes().getNamedItem("name").getTextContent());
            modernization.put("project.package", projectNode.getAttributes().getNamedItem("package").getTextContent());
            modernization.put("project.directory", Modernization.absolutePathOf(file, projectNode.getAttributes().getNamedItem("directory").getTextContent()));
            modernization.put("module.name", moduleNode.getAttributes().getNamedItem("name").getTextContent());
            modernization.put("artifact.name", artifactNode != null ? artifactNode.getAttributes().getNamedItem("name").getTextContent() : "");
            modernization.put("definitions.excluded", definitionsNode != null ? definitionsNode.getAttributes().getNamedItem("excluded").getTextContent() : "");
            if (roomsNode != null) {
                modernization.put("rooms", String.join((CharSequence)",", Modernization.roomsOf(roomsNode)));
            }
            return modernization;
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    private static List<String> roomsOf(org.w3c.dom.Node roomsNode) {
        NodeList childNodes = roomsNode.getChildNodes();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            org.w3c.dom.Node item = childNodes.item(i);
            if (!item.getNodeName().equals("room")) continue;
            result.add(item.getTextContent());
        }
        return result;
    }

    private static String absolutePathOf(File file, String relativeFile) {
        if (!relativeFile.startsWith(".")) {
            return relativeFile;
        }
        return file.getParentFile().getAbsolutePath() + "/" + relativeFile;
    }
}

