/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionException;
import io.intino.goros.egeasy.m3.definition.dictionary.Dictionary;
import io.intino.goros.egeasy.m3.definition.dictionary.SerializerDictionary;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.generators.TreeDefinitionsGenerator;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.ArtifactRenderer;
import io.intino.goros.modernizing.egeasy.renderers.BoxRenderer;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRendererFactory;
import io.intino.goros.modernizing.egeasy.renderers.FileServiceRenderer;
import io.intino.goros.modernizing.egeasy.renderers.MainRenderer;
import io.intino.goros.modernizing.egeasy.renderers.ModelRenderer;
import io.intino.goros.modernizing.egeasy.renderers.ThemeRenderer;
import io.intino.goros.modernizing.egeasy.renderers.TranslationsRenderer;
import io.intino.goros.modernizing.egeasy.renderers.UIRenderer;
import io.intino.goros.modernizing.egeasy.renderers.definition.TaskSetRenderer;
import io.intino.goros.modernizing.egeasy.util.NamedThreadFactory;
import io.intino.goros.modernizing.egeasy.util.ZipUtil;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class EgeModernizer {
    private final Modernization modernization;
    private TreeNodeResource dictionary;
    private DefinitionRendererFactory factory = new DefinitionRendererFactory();

    public EgeModernizer(Modernization modernization) {
        this.modernization = modernization;
    }

    public void compile() {
        this.loadDictionary();
        this.createProjectSkeleton();
        this.compileDefinitions();
    }

    private void createProjectSkeleton() {
        try {
            Logger.info("Creating project skeleton");
            File projectDir = this.modernization.projectDirectory();
            if (projectDir.exists()) {
                Logger.info("Project skeleton already created");
                return;
            }
            projectDir.mkdirs();
            ZipUtil.decompress(EgeModernizer.class.getResourceAsStream("/skeleton.zip"), projectDir.getAbsolutePath());
            this.adaptSkeleton(projectDir);
            Logger.info("Project skeleton created");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void adaptSkeleton(File projectDir) throws IOException {
        String moduleName = this.modernization.moduleName();
        projectDir.mkdirs();
        Files.move(new File(projectDir + "/model").toPath(), new File(projectDir + "/" + moduleName).toPath(), new CopyOption[0]);
        Files.move(new File(projectDir + "/" + moduleName + "/model.iml").toPath(), new File(projectDir + "/" + moduleName + "/" + moduleName + ".iml").toPath(), new CopyOption[0]);
        String content = Files.readString(new File(projectDir + "/.idea/modules.xml").toPath());
        content = content.replace("/model", "/" + moduleName);
        Files.write(new File(projectDir + "/.idea/modules.xml").toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void compileDefinitions() {
        Logger.info("Compiling definitions");
        new ArtifactRenderer(this.dictionary, this.modernization).write();
        new MainRenderer(this.dictionary, this.modernization).write();
        new BoxRenderer(this.dictionary, this.modernization).write();
        new UIRenderer(this.dictionary, this.modernization, this.roomDefinitions()).write();
        new FileServiceRenderer(this.dictionary, this.modernization, this.roomDefinitions()).write();
        new ModelRenderer(this.dictionary, this.modernization, this.roomDefinitions()).write();
        new ThemeRenderer(this.dictionary, this.modernization).write();
        new TranslationsRenderer(this.dictionary, this.modernization).write();
        new TaskSetRenderer(this.dictionary, this.modernization).write();
        this.compileDefinitions(this.roomDefinitions());
        Logger.info("Definitions compiled");
    }

    private void compileDefinitions(List<Definition> definitions) {
        FrameBuilder.startCache();
        ExecutorService service = Executors.newFixedThreadPool(definitions.size() > 4 ? Runtime.getRuntime().availableProcessors() : 2, new NamedThreadFactory("displays"));
        definitions.stream().map(d -> () -> this.compileDefinition((Definition)d)).forEach(service::execute);
        try {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Logger.error(e);
        }
        FrameBuilder.stopCache();
    }

    private List<Definition> roomDefinitions() {
        return this.dictionary.getDefinitions().stream().filter(this::includeRoom).collect(Collectors.toList());
    }

    private boolean includeRoom(Definition d) {
        Boolean isRoomDefinition = DefinitionUtils.isRoomDefinition(d);
        if (!isRoomDefinition.booleanValue()) {
            return false;
        }
        List<String> rooms = this.modernization.rooms();
        if (rooms == null) {
            return true;
        }
        return rooms.contains(d.getName());
    }

    private void compileDefinition(Definition definition) {
        this.factory.renderer(this.dictionary, this.modernization, definition).write();
        FrameBuilder.clearCache();
    }

    private void loadDictionary() {
        try {
            Logger.info("Loading dictionary from " + this.modernization.dictionary().getAbsolutePath());
            SerializerDictionary serializer = new SerializerDictionary();
            serializer.deserializeDictionary(this.modernization.dictionary().getAbsolutePath(), Metamodel.getInstance().getBaseTypes());
            if (Dictionary.getInstance() == null) {
                Logger.error("Could not obtain dictionary. Path: " + this.modernization.dictionary().getAbsolutePath());
                return;
            }
            Dictionary.getInstance().activeInheritance();
            Logger.info("Creating resources structure...");
            Dictionary.getInstance().activeInheritance();
            TreeDefinitionsGenerator treeDefGenerator = new TreeDefinitionsGenerator();
            this.dictionary = treeDefGenerator.createTreeResourcesDefinitions(Dictionary.getInstance());
            if (this.dictionary == null) {
                Logger.error("Could not obtain resources tree of dictionary. Path:" + this.modernization.dictionary().getAbsolutePath());
                return;
            }
            Logger.info("Dictionary loaded. Definitions count: " + this.dictionary.getDefinitions().size());
        }
        catch (DefinitionException | IOException e) {
            Logger.error(e);
        }
    }
}

