/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;

public class DateUtils {
    private static final double NULL_DATE = 0.0;
    private static final int MILISECONDS_PER_DAY = 86400000;

    public static Instant doubleToInstant(Double value) {
        if (value == 0.0) {
            return null;
        }
        Double days = Math.floor(value);
        Double partOfDay = value - days;
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(1899, 11, 30, 0, 0, 0);
        c.add(5, days.intValue());
        c.set(14, (int)Math.round(partOfDay * 8.64E7));
        return c.toInstant();
    }

    public static Double instantToDouble(Instant value) {
        if (value == null) {
            return 0.0;
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(1899, 11, 30, 0, 0, 0);
        c.set(14, 0);
        long dateValueInitialdelphiInMs = c.toInstant().toEpochMilli();
        Long timeDiff = value.toEpochMilli() - dateValueInitialdelphiInMs;
        Long days = timeDiff / 86400000L;
        timeDiff = timeDiff % 86400000L;
        return (double)days.longValue() + (double)timeDiff.longValue() / 8.64E7;
    }

    public static ZonedDateTime defaultDate() {
        return ZonedDateTime.of(1899, 11, 30, 0, 0, 0, 0, ZoneId.systemDefault());
    }
}

