/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.serializer;

import io.intino.goros.egeasy.m3.entity.TGVariant;
import io.intino.goros.egeasy.m3.library.LibraryStream;
import io.intino.goros.egeasy.m3.serializer.SerializedStream;
import io.intino.goros.egeasy.m3.serializer.SerializerStatus;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.time.ZonedDateTime;

public class SerializedOutputStream
extends SerializedStream {
    private FastByteArrayOutputStream stream = new FastByteArrayOutputStream();

    public byte[] getBytes() {
        return this.stream.array;
    }

    @Override
    public long getPosition() {
        return this.stream.position();
    }

    @Override
    public void setPosition(Long value) {
        this.stream.position(value);
    }

    @Override
    public void close() throws IOException {
        long posSave = this.getPosition();
        long posFieldCount = this.popPosition();
        int fieldCount = this.getStackStatus().peek().getFieldCount();
        this.popPosition();
        this.setPosition(posFieldCount);
        LibraryStream.writeInt(this.stream, fieldCount);
        this.setPosition(posSave);
        this.getStackStatus().pop();
    }

    public void openWrite() throws IOException {
        this.pushPosition();
        LibraryStream.writeByte(this.stream, (byte)-6);
        this.pushPosition();
        LibraryStream.writeInt(this.stream, 0);
        this.getStackStatus().push(new SerializerStatus());
    }

    private void writeFieldHeader(SerializedStream.FieldHeader fieldHeader) throws IOException {
        this.pushPosition();
        LibraryStream.writeString(this.stream, fieldHeader.name, false);
        LibraryStream.writeInt(this.stream, fieldHeader.type);
        this.addField(fieldHeader.name, fieldHeader.type);
    }

    public void writeFieldVariant(String name, TGVariant value, boolean autoClose) throws IOException, TGVariant.EGVariant {
        this.writeFieldHeader(new SerializedStream.FieldHeader(name, 2));
        LibraryStream.writeVariant(this.stream, value);
        if (autoClose) {
            this.closeFieldVariant();
        } else {
            this.getStackFieldtype().push(2);
        }
        this.incrementFieldCount();
    }

    private void closeFieldVariant() {
        this.popPosition();
    }

    public void writeFieldStream(String name, boolean autoClose) throws IOException {
        this.writeFieldHeader(new SerializedStream.FieldHeader(name, 3));
        this.pushPosition();
        LibraryStream.writeInt(this.stream, 0);
        if (autoClose) {
            this.closeFieldStream();
        } else {
            this.getStackFieldtype().push(3);
        }
        this.incrementFieldCount();
    }

    private void closeFieldStream() throws IOException {
        long posSave = this.getPosition();
        long posSize = this.popPosition();
        this.setPosition(posSize);
        long size = posSave - posSize - 4L;
        LibraryStream.writeInt(this.stream, (int)size);
        this.setPosition(posSave);
        this.popPosition();
    }

    public void writeFieldRegister(String name, int fieldCount, boolean autoClose) throws IOException {
        this.writeFieldHeader(new SerializedStream.FieldHeader(name, 4));
        LibraryStream.writeInt(this.stream, fieldCount);
        if (autoClose) {
            this.closeFieldRegister();
        } else {
            this.getStackFieldtype().push(4);
        }
        this.incrementFieldCount();
    }

    private void closeFieldRegister() {
        this.popPosition();
    }

    public void writeFieldArrayVariant(String name, TGVariant[] value, boolean autoClose) throws IOException, TGVariant.EGVariant {
        this.writeFieldHeader(new SerializedStream.FieldHeader(name, 5));
        LibraryStream.writeInt(this.stream, value.length);
        for (int i = 0; i < value.length; ++i) {
            LibraryStream.writeVariant(this.stream, value[i]);
        }
        if (autoClose) {
            this.closeFieldArrayVariant();
        } else {
            this.getStackFieldtype().push(5);
        }
        this.incrementFieldCount();
    }

    private void closeFieldArrayVariant() {
        this.popPosition();
    }

    public void writeFieldArrayStream(String name, int streamCount, boolean autoClose) throws IOException {
        this.writeFieldHeader(new SerializedStream.FieldHeader(name, 6));
        LibraryStream.writeInt(this.stream, streamCount);
        if (autoClose) {
            this.closeFieldArrayStream();
        } else {
            this.getStackFieldtype().push(6);
        }
        this.incrementFieldCount();
    }

    private void closeFieldArrayStream() {
        this.popPosition();
    }

    private void incrementFieldCount() {
        this.getStackStatus().peek().incrementFieldCount();
    }

    public void writeStream() throws IOException {
        this.pushPosition();
        LibraryStream.writeInt(this.stream, 0);
    }

    public void closeStream() throws IOException {
        long posSave = this.getPosition();
        long posSize = this.popPosition();
        this.setPosition(posSize);
        long size = posSave - posSize - 4L;
        LibraryStream.writeInt(this.stream, (int)size);
        this.setPosition(posSave);
    }

    public void closeField() throws IOException {
        int fieldType = this.getStackFieldtype().pop();
        switch (fieldType) {
            case 2: {
                this.closeFieldVariant();
                break;
            }
            case 3: {
                this.closeFieldStream();
                break;
            }
            case 4: {
                this.closeFieldRegister();
                break;
            }
            case 5: {
                this.closeFieldArrayVariant();
                break;
            }
            case 6: {
                this.closeFieldArrayStream();
            }
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        LibraryStream.writeBoolean(this.stream, value);
    }

    public void writeInt(int value) throws IOException {
        LibraryStream.writeInt(this.stream, value);
    }

    public void writeString(String value, boolean wide) throws IOException {
        LibraryStream.writeString(this.stream, value, wide);
    }

    public void writeDateTime(ZonedDateTime value) throws IOException {
        LibraryStream.writeDateTime(this.stream, value);
    }

    public void writeVariant(TGVariant value) throws IOException, TGVariant.EGVariant {
        LibraryStream.writeVariant(this.stream, value);
    }
}

