/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.library;

import io.intino.goros.egeasy.m3.entity.document.TGDocument;
import io.intino.goros.egeasy.m3.entity.resource.TGContainer;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.egeasy.m3.library.LibraryFiles;

public class LibraryDocuments {
    public static TGDocument getDocument(TGContainer container) {
        return container.getComponents().getAComponents().stream().filter(item -> item instanceof TGDocument).findFirst().orElse(null);
    }

    public static TGDocument getOpenableDocument(TGContainer container) {
        TGDocument document = LibraryDocuments.getDocument(container);
        if (document == null) {
            return null;
        }
        if (LibraryFiles.isFilePDF(document.getFileName())) {
            return document;
        }
        if (!LibraryDefinitions.getAtAutomaticEdition(document.getDefinition())) {
            return document;
        }
        return null;
    }

    public static boolean isOpenableWorkDocument(TGContainer container) {
        TGDocument document = LibraryDocuments.getDocument(container);
        if (document == null) {
            return false;
        }
        return document.getIdFileBeforeSign() != -1;
    }

    public static boolean isEditableDocument(TGContainer container) {
        if (!container.getStatus().isEdition()) {
            return false;
        }
        if (container.getStatus().isProtect()) {
            return false;
        }
        TGDocument document = LibraryDocuments.getDocument(container);
        if (document == null) {
            return false;
        }
        if (document.getIdFileBeforeSign() != -1) {
            return false;
        }
        return LibraryFiles.isFileODT(document.getFileName());
    }

    public static boolean canCreateFromTemplate(TGContainer container) {
        if (!container.getStatus().isEdition()) {
            return false;
        }
        if (container.getStatus().isProtect()) {
            return false;
        }
        TGDocument document = LibraryDocuments.getDocument(container);
        if (document == null) {
            return false;
        }
        if (document.getIdFileBeforeSign() != -1) {
            return false;
        }
        return document.getIdFile() == -1;
    }

    public static boolean canSaveEE03Signature(TGContainer container) {
        if (container.getStatus().isProtect()) {
            return false;
        }
        TGDocument document = LibraryDocuments.getDocument(container);
        if (document == null) {
            return false;
        }
        if (!LibraryDefinitions.getAtPlatinoSGRDEDocumentCertificateActive(document.getDefinition())) {
            return false;
        }
        if (document.getIdFile() == -1) {
            return false;
        }
        return LibraryFiles.isFilePDF(document.getFileName());
    }
}

