/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.library;

import io.intino.goros.egeasy.m3.definition.base.DefType;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.expressions.LibraryExpressions;
import io.intino.goros.egeasy.m3.model.EntitySetColumn;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class LibraryDefinitions {
    public static Definition findDefinition(int drc, ArrayList<Definition> list) {
        return LibraryDefinitions.findDefinition(drc, list.toArray(new Definition[list.size()]));
    }

    public static Definition findDefinition(int drc, Definition[] list) {
        for (Definition definition : list) {
            if (definition.getDRC() != drc) continue;
            return definition;
        }
        return null;
    }

    public static Definition findDefinition(String name, ArrayList<Definition> list) {
        return LibraryDefinitions.findDefinition(name, list.toArray(new Definition[list.size()]));
    }

    public static Definition findDefinition(String name, Definition[] list) {
        for (Definition definition : list) {
            if (!definition.getName().equals(name)) continue;
            return definition;
        }
        return null;
    }

    public static Definition findDefinition(int drc, Definition domain, boolean findInParents) {
        Definition result = null;
        while (domain != null) {
            result = LibraryDefinitions.findDefinition(drc, domain.getDefinitions().toArray(new Definition[domain.getDefinitions().size()]));
            if (result != null) {
                return result;
            }
            if (findInParents) {
                domain = domain.getParent();
                continue;
            }
            domain = null;
        }
        return null;
    }

    public static Definition findDefinition(String name, Definition domain, boolean findInParents) {
        Definition result = null;
        while (domain != null) {
            result = LibraryDefinitions.findDefinition(name, domain.getDefinitions().toArray(new Definition[domain.getDefinitions().size()]));
            if (result != null) {
                return result;
            }
            if (findInParents) {
                domain = domain.getParent();
                continue;
            }
            domain = null;
        }
        return null;
    }

    public static List<Definition> findDefinitions(int[] DRCs, List<DefType> list) {
        List aDRCs = Arrays.stream(DRCs).boxed().collect(Collectors.toList());
        return list.stream().filter(definition -> aDRCs.indexOf(definition.getDRC()) >= 0).collect(Collectors.toList());
    }

    public static List<EntitySetColumn> getEntitySetColumns(Definition definition) {
        String linkValuesExpression = DefinitionUtils.getDefinitionAttributeValue(definition, "VINCULO.VALORES");
        List<EntitySetColumn> entitySetColumns = LibraryDefinitions.isLinkValuesExpresionSQL(linkValuesExpression) != false ? LibraryDefinitions.getEntitySetColumnsByExpression(definition, linkValuesExpression) : LibraryDefinitions.getEntitySetColumnsByDefinition(definition);
        return entitySetColumns == null ? Collections.emptyList() : entitySetColumns;
    }

    private static Boolean isLinkValuesExpresionSQL(String expression) {
        return expression != null && LibraryExpressions.isExpresionMatrixSQL(expression) != false;
    }

    private static List<EntitySetColumn> getEntitySetColumnsByDefinition(Definition definition) {
        if (DefinitionUtils.isCollectionDefinition(definition).booleanValue()) {
            return LibraryExpressions.getEntitySetColumnsByCollection(definition);
        }
        if (DefinitionUtils.isCatalogDefinition(definition).booleanValue()) {
            return LibraryExpressions.getEntitySetColumnsByCatalog(definition);
        }
        return Collections.emptyList();
    }

    private static List<EntitySetColumn> getEntitySetColumnsByExpression(Definition definition, String expression) {
        String contentExpression = LibraryExpressions.getExpressionFromMatrixSQLFunction(expression);
        if (contentExpression == null) {
            return Collections.emptyList();
        }
        return LibraryExpressions.isExpressionSQL(contentExpression) ? LibraryExpressions.getEntitySetColumnsBySQL(contentExpression) : LibraryDefinitions.getEntitySetColumnsByExpressionComponent(definition, contentExpression);
    }

    private static List<EntitySetColumn> getEntitySetColumnsByExpressionComponent(Definition definition, String expression) {
        String targetExpression = LibraryExpressions.getTargetExpressionFromLinkValues(expression);
        return targetExpression == null || targetExpression.isEmpty() ? Collections.emptyList() : LibraryExpressions.getEntitySetColumnsByTarget(definition, targetExpression);
    }

    public static boolean getAtAutomaticEdition(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("EDICION_AUTOMATICA");
        if (attributeValues.isEmpty()) {
            return false;
        }
        return attributeValues.get(0).equals("S");
    }

    public static boolean getAtIsRoot(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("ES_RAIZ");
        if (attributeValues.isEmpty()) {
            return false;
        }
        return attributeValues.get(0).equals("S");
    }

    public static boolean getAtPlatinoSGRDEDocumentCertificateActive(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("PLATINO_SGRDE_FIRMA_COPIA.ACTIVO");
        if (attributeValues.isEmpty()) {
            return false;
        }
        return attributeValues.get(0).equals("S");
    }

    public static int[] getAtTargetTypes(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("DESTINO.DEFINICION");
        if (attributeValues.isEmpty()) {
            return null;
        }
        return attributeValues.stream().mapToInt(Integer::parseInt).toArray();
    }

    public static String getAtFieldSignature(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("CAMPO_FIRMA");
        if (attributeValues.isEmpty()) {
            return null;
        }
        return attributeValues.get(0);
    }

    public static String getAtFieldApproval(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("CAMPO_VISTO_BUENO");
        if (attributeValues.isEmpty()) {
            return null;
        }
        return attributeValues.get(0);
    }

    public static String getAtLabel(Definition definition) {
        List<String> attributeValues = definition.getAttributes().findAttribute("ETIQUETA");
        return !attributeValues.isEmpty() ? attributeValues.get(0) : null;
    }
}

