/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.definition.dictionary;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.DefType;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionException;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtension;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionAccess;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionColumn;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionCompetence;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionCondition;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionConfidentialityField;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionConfidentialityKey;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionConfidentialityRole;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionContent;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionDivision;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionExternalValuesFile;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionExternalValuesSentence;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionInclude;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionKey;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionLocation;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionMarker;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionMetadata;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionSearch;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionSign;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionStamp;
import io.intino.goros.egeasy.m3.definition.base.DefinitionExtensionValues;
import io.intino.goros.egeasy.m3.definition.dictionary.Dictionary;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.egeasy.m3.library.LibraryStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SerializerDictionary {
    private static final String EXT_TMP = ".tmp";
    private static final String EXT_NDM = ".Ndm";
    private static final String FILE_DICTIONARY_PREFIX = "Dictionary";
    private Map<String, Boolean> modulesLoaded = new LinkedHashMap<String, Boolean>();
    private Map<String, InputStream> modulesStream = new LinkedHashMap<String, InputStream>();

    public void deserializeDictionary(String filename, DefType[] externalDefinitions) throws IOException, DefinitionException {
        File file = new File(filename);
        this.deserializeDictionary(file, externalDefinitions);
    }

    public void deserializeDictionary(File file, DefType[] externalDefinitions) throws IOException, DefinitionException {
        if (!file.exists()) {
            throw new IOException("Dictionary file not found (" + file.getAbsolutePath() + ")");
        }
        this.processCompressedDictionary(file, externalDefinitions);
        Dictionary.getInstance().setLoaded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompressedDictionary(File file, DefType[] externalDefinitions) throws IOException, DefinitionException {
        Dictionary.getInstance().loadExternalDefinitions(externalDefinitions);
        ZipFile zf = new ZipFile(file);
        if (zf.size() == 1 && zf.entries().nextElement().getName().endsWith(EXT_TMP)) {
            Enumeration<? extends ZipEntry> e = zf.entries();
            try (BufferedInputStream stream = new BufferedInputStream(zf.getInputStream(e.nextElement()));){
                this.deserializeDictionary(stream);
                return;
            }
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith(EXT_NDM)) continue;
            BufferedInputStream stream = new BufferedInputStream(zf.getInputStream(entry));
            String moduleName = this.calculateModuleName(entry.getName());
            this.modulesLoaded.put(moduleName, false);
            this.modulesStream.put(moduleName, stream);
        }
        try {
            String[] aModules;
            Set<String> moduleNames = this.modulesStream.keySet();
            for (String moduleName : aModules = moduleNames.toArray(new String[moduleNames.size()])) {
                this.deserializeModuleDictionary(moduleName);
            }
        }
        finally {
            this.closeAllStreams();
        }
    }

    private String calculateModuleName(String fileName) {
        String module = fileName.substring(FILE_DICTIONARY_PREFIX.length() + 1);
        int pos = module.indexOf(".");
        return module.substring(0, pos);
    }

    private void closeAllStreams() throws IOException {
        for (String moduleName : this.modulesStream.keySet()) {
            this.modulesStream.get(moduleName).close();
        }
        this.modulesStream.clear();
    }

    private void deserializeModuleDictionary(String moduleName) throws DefinitionException, IOException {
        if (this.modulesLoaded.get(moduleName).booleanValue()) {
            return;
        }
        this.modulesLoaded.put(moduleName, true);
        InputStream stream = this.modulesStream.get(moduleName);
        if (stream == null) {
            return;
        }
        try {
            this.deserializeDictionary(stream);
        }
        finally {
            this.modulesStream.remove(moduleName);
            stream.close();
        }
    }

    private void deserializeDictionary(InputStream stream) throws DefinitionException {
        int code;
        try {
            code = LibraryStream.readUnsignedByte(stream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read code", e);
        }
        if (code != 144 && code != 147) {
            throw new DefinitionException("Can't read code");
        }
        try {
            int len = LibraryStream.readInt(stream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read len", e);
        }
        this.deserializeHeader(Dictionary.getInstance(), stream);
        if (code == 147) {
            this.deserializeDictionaryDependencies(stream);
        }
        this.deserializeDefinitionItems(Dictionary.getInstance(), stream, null);
    }

    private void deserializeHeader(Dictionary dictionary, InputStream inputStream) throws DefinitionException {
        try {
            dictionary.setTitle(LibraryStream.readString(inputStream, true));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read header title", e);
        }
        try {
            dictionary.setCreationDate(LibraryStream.readDateTime(inputStream));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read header creation date", e);
        }
        try {
            dictionary.setVersion(LibraryStream.readString(inputStream, true));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read header version", e);
        }
        try {
            dictionary.setLastDRC(LibraryStream.readInt(inputStream));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read header last drc", e);
        }
    }

    private void deserializeDictionaryDependencies(InputStream inputStream) throws DefinitionException {
        int count;
        try {
            count = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read dependency count", e);
        }
        for (int i = 0; i < count; ++i) {
            try {
                String dependency = LibraryStream.readString(inputStream, true);
                this.deserializeModuleDictionary(dependency);
                continue;
            }
            catch (Exception e) {
                throw new DefinitionException("Can't read dependency count", e);
            }
        }
    }

    private void deserializeDefinitionItems(Dictionary dictionary, InputStream inputStream, Definition domain) throws DefinitionException {
        int count;
        try {
            int n = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read definitions length", e);
        }
        try {
            count = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read definitions count", e);
        }
        for (int i = 0; i < count; ++i) {
            int code;
            try {
                code = LibraryStream.readUnsignedByte(inputStream);
            }
            catch (Exception e) {
                throw new DefinitionException("Can't read code", e);
            }
            if (code != 146) {
                throw new DefinitionException("Can't read code");
            }
            try {
                int len = LibraryStream.readInt(inputStream);
            }
            catch (Exception e) {
                throw new DefinitionException("Can't read definition length", e);
            }
            this.deserializeDefinition(dictionary, inputStream, null);
        }
    }

    private void deserializeDefinitions(Dictionary dictionary, InputStream inputStream, Definition domain) throws DefinitionException {
        int count;
        try {
            int len = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read definitions length", e);
        }
        try {
            count = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read definitions count", e);
        }
        for (int i = 0; i < count; ++i) {
            this.deserializeDefinition(dictionary, inputStream, domain);
        }
    }

    private void deserializeDefinition(Dictionary dictionary, InputStream inputStream, Definition domain) throws DefinitionException {
        String attributes;
        int drcParent;
        int code;
        try {
            code = LibraryStream.readUnsignedByte(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read code", e);
        }
        Class classDefinition = this.findClassDefinition(code);
        Definition definition = dictionary.createDefinition(classDefinition, domain);
        if ((code & 0x1F) != 0) {
            Class classExtension = this.findClassExtension(code);
            definition.extend(classExtension);
        }
        try {
            definition.setDRC(LibraryStream.readInt(inputStream));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read drc", e);
        }
        try {
            drcParent = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read drc parent", e);
        }
        if (definition instanceof DefType) {
            try {
                ((DefType)definition).setAbstract(LibraryStream.readBoolean(inputStream));
            }
            catch (Exception e) {
                throw new DefinitionException("Can't read abstract", e);
            }
        }
        try {
            definition.setName(LibraryStream.readString(inputStream, true));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read name", e);
        }
        try {
            definition.setTypeValue(LibraryStream.readInt(inputStream));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read type value", e);
        }
        try {
            attributes = LibraryStream.readString(inputStream, true);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read attributes", e);
        }
        definition.getAttributes().setContent(attributes);
        this.addToParent(dictionary, definition, domain, drcParent);
        this.deserializeDefinitions(dictionary, inputStream, definition);
        this.deserializeExtension(dictionary, definition.getExtension(), inputStream);
    }

    private Class findClassDefinition(int code) throws DefinitionException {
        switch (code &= 0xE0) {
            case 160: {
                return DefType.class;
            }
            case 192: {
                return DefInstance.class;
            }
        }
        throw new DefinitionException("Definition code error");
    }

    private Class findClassExtension(int code) throws DefinitionException {
        switch (code) {
            case 201: {
                return DefinitionExtensionAccess.class;
            }
            case 209: {
                return DefinitionExtensionColumn.class;
            }
            case 202: {
                return DefinitionExtensionCompetence.class;
            }
            case 210: {
                return DefinitionExtensionCondition.class;
            }
            case 219: {
                return DefinitionExtensionConfidentialityField.class;
            }
            case 218: {
                return DefinitionExtensionConfidentialityKey.class;
            }
            case 220: {
                return DefinitionExtensionConfidentialityRole.class;
            }
            case 205: {
                return DefinitionExtensionContent.class;
            }
            case 216: {
                return DefinitionExtensionDivision.class;
            }
            case 204: {
                return DefinitionExtensionExternalValuesFile.class;
            }
            case 213: {
                return DefinitionExtensionExternalValuesSentence.class;
            }
            case 206: {
                return DefinitionExtensionInclude.class;
            }
            case 214: {
                return DefinitionExtensionKey.class;
            }
            case 207: {
                return DefinitionExtensionLocation.class;
            }
            case 208: {
                return DefinitionExtensionMarker.class;
            }
            case 222: {
                return DefinitionExtensionMetadata.class;
            }
            case 215: {
                return DefinitionExtensionSearch.class;
            }
            case 211: {
                return DefinitionExtensionSign.class;
            }
            case 217: {
                return DefinitionExtensionStamp.class;
            }
            case 203: {
                return DefinitionExtensionValues.class;
            }
        }
        throw new DefinitionException("Definition extension code error");
    }

    private void addToParent(Dictionary dictionary, Definition definition, Definition domain, int drcParent) throws DefinitionException {
        Definition defParent;
        if (drcParent == 0) {
            defParent = null;
        } else if (drcParent == -1) {
            if (!(definition instanceof DefInstance)) {
                throw new DefinitionException("Wrong parent drc");
            }
            defParent = LibraryDefinitions.findDefinition(definition.getName(), domain, true);
            if (defParent == null && (defParent = LibraryDefinitions.findDefinition(drcParent, dictionary.getDefInstances().toArray(new Definition[dictionary.getDefInstances().size()]))) == null) {
                throw new DefinitionException("Wrong parent drc " + String.valueOf(drcParent));
            }
        } else {
            defParent = dictionary.findDefinition(drcParent);
            if (defParent == null) {
                throw new DefinitionException("Wrong parent drc " + String.valueOf(drcParent));
            }
        }
        definition.setParent(defParent);
        if (definition instanceof DefInstance) {
            ((DefInstance)definition).setDomain(domain);
        }
    }

    private void deserializeExtension(Dictionary dictionary, DefinitionExtension extension, InputStream inputStream) throws DefinitionException {
        if (extension == null) {
            return;
        }
        if (extension instanceof DefinitionExtensionAccess) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionAccess)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionColumn) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionColumn)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionCompetence) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionCompetence)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionCondition) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionCondition)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionConfidentialityField) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionConfidentialityField)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionConfidentialityKey) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionConfidentialityKey)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionConfidentialityRole) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionConfidentialityRole)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionContent) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionContent)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionDivision) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionDivision)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionExternalValuesFile) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionExternalValuesFile)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionExternalValuesSentence) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionExternalValuesSentence)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionInclude) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionInclude)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionKey) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionKey)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionLocation) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionLocation)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionMarker) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionMarker)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionMetadata) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionMetadata)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionSearch) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionSearch)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionSign) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionSign)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionStamp) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionStamp)extension, inputStream);
        } else if (extension instanceof DefinitionExtensionValues) {
            this.doDeserializeExtension(dictionary, (DefinitionExtensionValues)extension, inputStream);
        }
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionAccess extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defAccessed = dictionary.findDefinition(drc);
        if (defAccessed == null) {
            throw new DefinitionException("Can't find accessed definition");
        }
        extension.setDefinitionAccessed(defAccessed);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionColumn extension, InputStream inputStream) throws DefinitionException {
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionCompetence extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defTask = dictionary.findDefinition(drc);
        if (defTask == null) {
            throw new DefinitionException("Can't find task definition");
        }
        extension.setDefinitionTask(defTask);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionCondition extension, InputStream inputStream) throws DefinitionException {
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionConfidentialityField extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defResource = dictionary.findDefinition(drc);
        if (defResource == null) {
            throw new DefinitionException("Can't find resource definition");
        }
        extension.setDefinitionResource(defResource);
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defField = LibraryDefinitions.findDefinition(drc, dictionary.getDefinitions().toArray(new Definition[dictionary.getDefinitions().size()]));
        if (defField == null) {
            throw new DefinitionException("Can't find field definition");
        }
        extension.setDefinitionField(defField);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionConfidentialityKey extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defResource = dictionary.findDefinition(drc);
        if (defResource == null) {
            throw new DefinitionException("Can't find resource definition");
        }
        extension.setDefinitionResource(defResource);
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defField = LibraryDefinitions.findDefinition(drc, dictionary.getDefinitions().toArray(new Definition[dictionary.getDefinitions().size()]));
        if (defField == null) {
            throw new DefinitionException("Can't find field definition");
        }
        extension.setDefinitionField(defField);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionConfidentialityRole extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defRole = dictionary.findDefinition(drc);
        if (defRole == null) {
            throw new DefinitionException("Can't find role definition");
        }
        extension.setDefinitionRole(defRole);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionContent extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defContained = dictionary.findDefinition(drc);
        if (defContained == null) {
            throw new DefinitionException("Can't find contained definition");
        }
        extension.setDefinitionContained(defContained);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionDivision extension, InputStream inputStream) throws DefinitionException {
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionExternalValuesFile extension, InputStream inputStream) throws DefinitionException {
        try {
            extension.setSource(LibraryStream.readString(inputStream, true));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionExternalValuesSentence extension, InputStream inputStream) throws DefinitionException {
        try {
            extension.setSource(LibraryStream.readString(inputStream, true));
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionInclude extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defIncluded = dictionary.findDefinition(drc);
        if (defIncluded == null) {
            throw new DefinitionException("Can't find included definition");
        }
        extension.setDefinitionIncluded(defIncluded);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionKey extension, InputStream inputStream) throws DefinitionException {
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionLocation extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defLocated = dictionary.findDefinition(drc);
        if (defLocated == null) {
            throw new DefinitionException("Can't find located definition");
        }
        extension.setDefinitionLocated(defLocated);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionMarker extension, InputStream inputStream) throws DefinitionException {
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionMetadata extension, InputStream inputStream) throws DefinitionException {
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionSearch extension, InputStream inputStream) throws DefinitionException {
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionSign extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defContainer = LibraryDefinitions.findDefinition(drc, dictionary.getDefinitions().toArray(new Definition[dictionary.getDefinitions().size()]));
        if (defContainer == null) {
            throw new DefinitionException("Can't find container definition");
        }
        extension.setDefinitionContainer(defContainer);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionStamp extension, InputStream inputStream) throws DefinitionException {
        int drc;
        try {
            drc = LibraryStream.readInt(inputStream);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields", e);
        }
        Definition defContainer = LibraryDefinitions.findDefinition(drc, dictionary.getDefinitions().toArray(new Definition[dictionary.getDefinitions().size()]));
        if (defContainer == null) {
            throw new DefinitionException("Can't find container definition");
        }
        extension.setDefinitionContainer(defContainer);
    }

    private void doDeserializeExtension(Dictionary dictionary, DefinitionExtensionValues extension, InputStream inputStream) throws DefinitionException {
        String values;
        try {
            values = LibraryStream.readString(inputStream, true);
        }
        catch (Exception e) {
            throw new DefinitionException("Can't read extension fields, e");
        }
        String[] arrayValues = values.split(Pattern.quote("\r\n"));
        extension.getValues().addAll(Arrays.asList(arrayValues));
    }
}

