/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.configuration;

import io.intino.goros.egeasy.m3.configuration.DBConfiguration;
import io.intino.goros.egeasy.m3.configuration.DBType;
import io.intino.goros.egeasy.m3.configuration.EGEConfiguration;
import io.intino.goros.egeasy.m3.constant.Constants;
import org.json.JSONObject;

public class SerializerConfigurationJSON {
    public void unserialize(EGEConfiguration target, byte[] content) {
        try {
            String conf = new String(content);
            JSONObject jsonConfiguration = new JSONObject(conf);
            if (jsonConfiguration.has("CenterName")) {
                target.setCenterName(jsonConfiguration.getString("CenterName"));
            }
            if (jsonConfiguration.has("ModelLocation")) {
                target.setModelLocation(jsonConfiguration.getString("ModelLocation"));
            }
            if (jsonConfiguration.has("RegistryLocation")) {
                target.setRegistryLocation(jsonConfiguration.getString("RegistryLocation"));
            }
            if (jsonConfiguration.has("DocumentLocation")) {
                target.setDocumentLocation(jsonConfiguration.getString("DocumentLocation"));
            }
            if (jsonConfiguration.has("DBConnectionJava")) {
                this.loadDBConfiguration(target.getDbConfiguration(), jsonConfiguration.getString("DBConnectionJava"));
            }
            if (jsonConfiguration.has("DBType")) {
                target.getDbConfiguration().setType(DBType.values()[jsonConfiguration.getInt("DBType")]);
            }
            if (jsonConfiguration.has("DataConnections")) {
                target.getDbConfiguration().setNumConnections(jsonConfiguration.getInt("DataConnections"));
            }
            if (jsonConfiguration.has("SystemWebURL")) {
                target.getEgSystemWebConnection().setUrl(jsonConfiguration.getString("SystemWebURL"));
            }
            if (jsonConfiguration.has("SystemWebPort")) {
                target.getEgSystemWebConnection().setPort(jsonConfiguration.getInt("SystemWebPort"));
            }
            if (jsonConfiguration.has("SystemWebProtocol")) {
                target.getEgSystemWebConnection().setBinderType(jsonConfiguration.getString("SystemWebProtocol"));
            }
            if (jsonConfiguration.has("CasEnabled")) {
                target.getCasConfiguration().setActive(jsonConfiguration.getBoolean("CasEnabled"));
            }
            if (jsonConfiguration.has("CasUrl")) {
                target.getCasConfiguration().setUrl(jsonConfiguration.getString("CasUrl"));
            }
            if (jsonConfiguration.has("EsbUrl")) {
                target.getEsbConfiguration().setUrl(jsonConfiguration.getString("EsbUrl"));
            }
            if (jsonConfiguration.has("EsbTimeout")) {
                target.getEsbConfiguration().setTimeout(jsonConfiguration.getInt("EsbTimeout"));
            }
            if (jsonConfiguration.has("Variables")) {
                target.getVariables();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isConnectionStringOracleJava(String connectionString) {
        return connectionString != null && connectionString.startsWith(Constants.ORACLE_CONECTOR_JAVA);
    }

    private void loadDBConfigurationOracleJava(DBConfiguration dbConfiguration, String connectionString) {
        int pos = (connectionString = connectionString.substring(Constants.ORACLE_CONECTOR_JAVA.length())).indexOf(47);
        if (pos < 0) {
            return;
        }
        String userName = connectionString.substring(0, pos);
        if ((pos = (connectionString = connectionString.substring(pos + 1)).indexOf(64)) < 0) {
            return;
        }
        String password = connectionString.substring(0, pos);
        String host = connectionString.substring(pos + 1);
        dbConfiguration.setUsername(userName);
        dbConfiguration.setPassword(password);
        dbConfiguration.setHost(host);
    }

    private void loadDBConfigurationOracle(DBConfiguration dbConfiguration, String connectionString) {
        String[] parts = connectionString.split("@");
        if (parts.length < 3) {
            return;
        }
        dbConfiguration.setUsername(parts[0]);
        dbConfiguration.setPassword(parts[2]);
        dbConfiguration.setHost(parts[1]);
    }

    private void loadDBConfiguration(DBConfiguration dbConfiguration, String connectionString) {
        if (this.isConnectionStringOracleJava(connectionString)) {
            this.loadDBConfigurationOracleJava(dbConfiguration, connectionString);
        } else {
            this.loadDBConfigurationOracle(dbConfiguration, connectionString);
        }
    }
}

