/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.documents.box.install;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.shared.install.Db;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class Install {
    private Db db;
    private String workspace;
    private String documentDisks;

    public Install(Map<String, String> parameters) {
        String DbUrl = parameters.get("jdbc-url");
        String DbUser = parameters.get("jdbc-user");
        String DbPassword = parameters.get("jdbc-password");
        this.db = new Db(DbUrl, DbUser, DbPassword);
        this.workspace = parameters.get("workspace");
        this.documentDisks = parameters.get("document-disks");
    }

    public void initWorkspace() {
        File f = new File(this.workspace);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void processDB() {
        if (!this.installedDb()) {
            Logger.info((String)"Install database...");
            String sqlScript = "/database/mysql.sql";
            InputStream in = Install.class.getResourceAsStream(sqlScript);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                this.db.executeScript((Reader)reader);
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void processFonts() {
        if (!this.installedFonts()) {
            String folderFonts = this.workspace + "/fonts";
            File f = new File(folderFonts);
            f.mkdirs();
            ArrayList<String> files = null;
            try {
                files = this.listFilesJar(this.getClass().getResource("/WEB-INF/user_data/fonts").getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            for (String filefont : files) {
                String filename = "/WEB-INF/user_data/fonts/" + filefont;
                InputStream in = Install.class.getResourceAsStream(filename);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                try {
                    io.intino.goros.shared.install.Files.saveReaderFile((Reader)reader, (File)new File(this.workspace + "/fonts/" + filefont));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void processDocumentDisks() {
        if (!this.installedFonts()) {
            File f = new File(this.documentDisks);
            f.mkdirs();
        }
    }

    private boolean installedDb() {
        try {
            String count = this.db.executeSentence("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = '" + this.db.getDbname() + "' and table_name = 'ds\\$documents'");
            return !count.isEmpty() && Integer.parseInt(count) > 0;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean installedFonts() {
        File f = new File(this.workspace + "/fonts");
        return f.exists() && f.isDirectory();
    }

    private boolean installedDocumentDisks() {
        File f = new File(this.documentDisks);
        return f.exists() && f.isDirectory();
    }

    private ArrayList<String> listFilesJar(String dirname) throws IOException, URISyntaxException {
        FileSystem fileSystem;
        String jarFile = "jar:" + dirname.substring(0, dirname.indexOf("jar!") + "jar".length());
        String pathRelative = dirname.substring(dirname.indexOf("jar!") + "jar!".length());
        URI uri = new URI(jarFile);
        try {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        catch (Exception e) {
            fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        final ArrayList<String> result = new ArrayList<String>();
        Files.walkFileTree(fileSystem.getPath(pathRelative, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                this.print(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                this.print(dir);
                return FileVisitResult.CONTINUE;
            }

            private void print(Path file) throws IOException {
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    result.add(file.getFileName().toString());
                }
            }
        });
        return result;
    }
}

