/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.documents.box.configuration;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.documents.box.configuration.DatabaseConfiguration;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.ConnectionPoolDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

public class DatabaseLoader {
    public static void load(DatabaseConfiguration configuration) {
        try {
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
            InitialContext initialContext = new InitialContext();
            initialContext.createSubcontext("java:");
            initialContext.createSubcontext("java:comp");
            initialContext.createSubcontext("java:comp/env");
            initialContext.createSubcontext("java:comp/env/jdbc");
            initialContext.bind("java:comp/env/" + configuration.datasource(), (Object)DatabaseLoader.dataSource(configuration));
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    private static ConnectionPoolDataSource dataSource(DatabaseConfiguration configuration) throws SQLException {
        switch (configuration.type()) {
            case MYSQL: {
                return DatabaseLoader.mysqlDataSource(configuration);
            }
            case ORACLE: {
                return DatabaseLoader.oracleDataSource(configuration);
            }
        }
        return null;
    }

    private static ConnectionPoolDataSource mysqlDataSource(DatabaseConfiguration configuration) {
        return DatabaseLoader.dataSource(configuration, "com.mysql.jdbc.Driver");
    }

    private static ConnectionPoolDataSource oracleDataSource(DatabaseConfiguration configuration) {
        return DatabaseLoader.dataSource(configuration, "oracle.jdbc.OracleDriver");
    }

    private static ConnectionPoolDataSource dataSource(DatabaseConfiguration configuration, String driver) {
        DataSource datasource = new DataSource();
        datasource.setPoolProperties((PoolConfiguration)DatabaseLoader.poolProperties(configuration, driver));
        return datasource;
    }

    private static PoolProperties poolProperties(DatabaseConfiguration configuration, String driver) {
        PoolProperties p = new PoolProperties();
        p.setUrl(configuration.url());
        p.setUsername(configuration.user());
        p.setPassword(configuration.password());
        p.setDriverClassName(driver);
        p.setMaxActive(15);
        p.setMaxIdle(2);
        p.setMaxWait(30000);
        p.setRemoveAbandonedTimeout(5);
        p.setLogAbandoned(true);
        p.setAccessToUnderlyingConnectionAllowed(true);
        p.setValidationQuery("SELECT 1");
        p.setValidationQueryTimeout(10);
        p.setValidationInterval(10000L);
        p.setTestOnBorrow(true);
        p.setJdbcInterceptors("org.apache.tomcat.jdbc.pool.interceptor.ConnectionState;org.apache.tomcat.jdbc.pool.interceptor.StatementFinalizer");
        return p;
    }
}

