/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.documents.box.configuration;

import io.intino.goros.documents.box.configuration.DatabaseConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.monet.docservice.core.exceptions.ApplicationException;
import org.monet.docservice.core.util.Resources;
import org.monet.docservice.docprocessor.configuration.Configuration;

public class ConfigurationImpl
implements Configuration {
    private final Map<String, String> parameters;
    private final DatabaseConfiguration database;
    private static Map<String, String> keyMap = new HashMap<String, String>(){
        {
            this.put("Jdbc.Database", "jdbc-type");
            this.put("Jdbc.DataSource", "jdbc-datasource");
            this.put("TrueTypeFonts", "true-type-fonts-path");
            this.put("Temp", "temp-path");
            this.put("WorkQueue.ThreadPoolSize", "workqueue-thread-pool-size");
            this.put("WorkQueue.CollectWorkPeriod", "workqueue-collect-work-period");
            this.put("Document.PreviewsCacheSizeInDays", "document-previews-cache-size-in-days");
            this.put("Document.Disks", "document-disks");
            this.put("PdfConverterClass", "pdf-converter-class");
            this.put("GeneratePdfA", "generate-pdf-a");
            this.put("ModelProducerClass", "model-producer-class");
            this.put("Height", "sign-height");
            this.put("OffsetX", "sign-offset-x");
            this.put("OffsetY", "sign-offset-y");
            this.put("OffsetYForBottom", "sign-offset-y-for-bottom");
            this.put("Count", "sign-count");
            this.put("PdfLicencePath", "pdf-licence-path");
        }
    };

    public ConfigurationImpl(Map<String, String> parameters) {
        this.parameters = parameters;
        this.database = DatabaseConfiguration.fromMap(parameters);
    }

    public String getPath(String key) {
        return this.getString(key);
    }

    public String getJDBCDataSource() {
        return this.database.datasource();
    }

    public String getString(String key) {
        if (!this.existsParam(key)) {
            throw new ApplicationException(String.format("Configuration error, key '%s' not found", key));
        }
        return this.getParam(key);
    }

    public int getInt(String key) {
        return Integer.parseInt(this.getString(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public int getSignConfig(String key) {
        return this.getInt("Sign." + key);
    }

    public String getApplicationDir() {
        return Resources.getFullPath((String)"/");
    }

    public String getUpgradesDir() {
        return this.getApplicationDir() + "/upgrades";
    }

    public int getDocumentPreviewsCacheSize() {
        if (!this.existsParam("Document.PreviewsCacheSizeInDays")) {
            return 30;
        }
        return this.getInt("Document.PreviewsCacheSizeInDays");
    }

    public String getUserDataDir() {
        return this.parameters.get("workspace");
    }

    public String getLogsDir() {
        return this.getUserDataDir() + "/logs";
    }

    public String[] getDocumentDisks() {
        if (!this.existsParam("Document.Disks")) {
            return null;
        }
        String value = this.getString("Document.Disks");
        return !value.isEmpty() ? value.split(",") : null;
    }

    public void check() {
        if (this.getDocumentDisks() == null) {
            throw new ApplicationException(String.format("Configuration error, key '%s' not found", "Document.Disks"));
        }
    }

    private boolean existsParam(String paramName) {
        return keyMap.containsKey(paramName) && this.parameters.containsKey(keyMap.get(paramName));
    }

    private String getParam(String paramName) {
        if (!this.existsParam(paramName)) {
            return null;
        }
        return this.parameters.get(keyMap.get(paramName));
    }
}

