/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.documents.box.actions;

import com.google.inject.Injector;
import com.google.inject.Provider;
import io.intino.alexandria.Context;
import io.intino.alexandria.Resource;
import io.intino.goros.documents.box.actions.Action;
import io.intino.goros.documents.box.services.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.json.JSONSerializer;
import org.monet.docservice.core.Key;
import org.monet.docservice.core.exceptions.ApplicationException;
import org.monet.docservice.core.log.Logger;
import org.monet.docservice.core.util.Resources;
import org.monet.docservice.docprocessor.data.Repository;
import org.monet.docservice.docprocessor.model.Document;
import org.monet.docservice.docprocessor.model.DocumentMetadata;
import org.monet.docservice.docprocessor.worker.WorkQueue;
import org.monet.docservice.docprocessor.worker.WorkQueueItem;
import org.monet.docservice.guice.InjectorFactory;
import org.monet.filesystem.StreamHelper;

public abstract class PreviewDocumentAction
extends Action {
    public String thumb;
    public String space;
    public String id;
    public String page;
    private Logger logger;
    private Provider<Repository> repositoryProvider;
    private WorkQueue workQueue;
    private static final String JSON_MIMETYPE = "application/json";

    public PreviewDocumentAction() {
        Injector injector = InjectorFactory.get();
        this.logger = (Logger)injector.getInstance(Logger.class);
        this.repositoryProvider = injector.getProvider(Repository.class);
        this.workQueue = (WorkQueue)injector.getInstance(WorkQueue.class);
    }

    public Resource execute() {
        int pageNumber = -1;
        boolean isThumb = false;
        Key documentKey = new Key(this.space, this.id);
        this.generateDocumentPreviewIfNotExists(documentKey);
        this.response = new Response((Context)this.context);
        if (this.page != null) {
            try {
                pageNumber = Integer.parseInt(this.page);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.thumb != null) {
            try {
                pageNumber = Integer.parseInt(this.thumb);
                isThumb = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (documentKey.getId().length() != 0) {
            if (pageNumber > 0) {
                this.getPagePreviewData(this.response, documentKey, pageNumber, isThumb);
            } else {
                this.getDocumentMetadata(this.response, documentKey);
            }
        } else {
            this.response.getWriter().println("Invalid query string");
            return null;
        }
        return this.resource();
    }

    private void generateDocumentPreviewIfNotExists(Key documentKey) {
        Repository repository = (Repository)this.repositoryProvider.get();
        if (repository.existsDocumentPreview(documentKey)) {
            return;
        }
        if (this.workQueue.documentHasPendingOperationsOfType(documentKey, 3)) {
            return;
        }
        WorkQueueItem item = new WorkQueueItem(-1L);
        item.setDocumentKey(documentKey);
        item.setOperation(3);
        this.workQueue.queueNewWorkItem(item);
    }

    private void getDocumentMetadata(Response resp, Key documentKey) {
        Repository repository = (Repository)this.repositoryProvider.get();
        try {
            Document document = repository.getDocument(documentKey);
            DocumentMetadata metadata = repository.getDocumentMetadata(document);
            resp.setContentType(JSON_MIMETYPE);
            resp.getWriter().print(JSONSerializer.toJSON((Object)metadata).toString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ApplicationException("Error");
        }
    }

    private void getPagePreviewData(Response resp, Key documentKey, int iPage, boolean isThumb) {
        Repository repository = (Repository)this.repositoryProvider.get();
        try {
            int type = isThumb ? 1 : 2;
            String sContentType = repository.getDocumentPreviewDataContentType(documentKey, iPage, type);
            resp.setContentType(sContentType);
            resp.setHeader("Content-Disposition", String.format("attachment; filename=%s_%s.png", documentKey.toString(), iPage));
            repository.readDocumentPreviewData(documentKey, iPage, resp.getOutputStream(), type);
        }
        catch (Exception e) {
            resp.setContentType("image/png");
            resp.setHeader("Content-Disposition", String.format("attachment; filename=%s_%s.png", documentKey.toString(), iPage));
            InputStream img = isThumb ? Resources.getAsStream((String)"/images/defaultThumb.png") : Resources.getAsStream((String)"/images/default.png");
            try {
                StreamHelper.copy((InputStream)img, (OutputStream)resp.getOutputStream());
            }
            catch (IOException ioe) {
                this.logger.error(e.getMessage(), (Throwable)ioe);
            }
        }
    }
}

