/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.documents.box.actions;

import com.google.inject.Injector;
import com.google.inject.Provider;
import io.intino.alexandria.Context;
import io.intino.alexandria.Resource;
import io.intino.goros.documents.box.actions.Action;
import io.intino.goros.documents.box.services.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.commons.io.IOUtils;
import org.monet.docservice.core.Key;
import org.monet.docservice.core.exceptions.ApplicationException;
import org.monet.docservice.core.library.LibraryFile;
import org.monet.docservice.core.log.Logger;
import org.monet.docservice.core.util.MimeTypes;
import org.monet.docservice.core.util.Resources;
import org.monet.docservice.docprocessor.data.Repository;
import org.monet.docservice.docprocessor.worker.WorkQueue;
import org.monet.docservice.docprocessor.worker.WorkQueueItem;
import org.monet.docservice.guice.InjectorFactory;
import org.monet.filesystem.StreamHelper;

public class DownloadDocumentAction
extends Action {
    public String thumb;
    public String space;
    public String id;
    private Logger logger;
    private LibraryFile libraryFile;
    private Provider<Repository> repositoryProvider;
    private WorkQueue workQueue;
    private MimeTypes mimeTypes;

    public DownloadDocumentAction() {
        Injector injector = InjectorFactory.get();
        this.logger = (Logger)injector.getInstance(Logger.class);
        this.libraryFile = (LibraryFile)injector.getInstance(LibraryFile.class);
        this.repositoryProvider = injector.getProvider(Repository.class);
        this.workQueue = (WorkQueue)injector.getInstance(WorkQueue.class);
        this.mimeTypes = (MimeTypes)injector.getInstance(MimeTypes.class);
    }

    public Resource execute() {
        int page = -1;
        boolean isThumbnail = this.thumb != null;
        Key documentKey = new Key(this.space, this.id);
        this.response = new Response((Context)this.context);
        if (documentKey.getId().length() == 0) {
            this.response.getWriter().println("Invalid query string");
            return null;
        }
        this.getDownloadData(this.response, documentKey, page, isThumbnail);
        return this.resource();
    }

    private void getDownloadData(Response response, Key documentKey, int page, boolean isThumb) {
        InputStream documentData;
        block8: {
            Repository repository;
            block7: {
                repository = (Repository)this.repositoryProvider.get();
                documentData = null;
                if (repository.existsDocument(documentKey)) break block7;
                response.setStatus(404);
                response.setContentType("image/png");
                InputStream imageStream = Resources.getAsStream((String)"/not_found.gif");
                response.setContentLength(imageStream.available());
                this.copyData(imageStream, response.getOutputStream());
                StreamHelper.close((InputStream)documentData);
                return;
            }
            try {
                String contentType = repository.getDocumentDataContentType(documentKey);
                String extension = this.libraryFile.getExtension(documentKey.getId());
                if (extension == null) {
                    extension = this.mimeTypes.getExtension(contentType);
                }
                documentData = repository.getDocumentData(documentKey);
                String fileContentType = this.libraryFile.getContentType(documentData);
                StreamHelper.close((InputStream)documentData);
                response.setContentType(contentType);
                response.setHeader("Content-Disposition", String.format("attachment; filename=%s.%s", URLEncoder.encode(this.libraryFile.getFilenameWithoutExtension(documentKey.getId()), "UTF-8"), extension));
                if (isThumb && !this.mimeTypes.isImage(fileContentType)) {
                    this.generateDocumentPreviewIfNotExists(documentKey);
                    repository.readDocumentPreviewData(documentKey, 1, response.getOutputStream(), 2);
                    break block8;
                }
                documentData = repository.getDocumentData(documentKey);
                IOUtils.copy((InputStream)documentData, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                try {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    throw new ApplicationException("Error");
                }
                catch (Throwable throwable) {
                    StreamHelper.close(documentData);
                    throw throwable;
                }
            }
        }
        StreamHelper.close((InputStream)documentData);
    }

    private void generateDocumentPreviewIfNotExists(Key documentKey) {
        Repository repository = (Repository)this.repositoryProvider.get();
        if (repository.existsDocumentPreview(documentKey)) {
            return;
        }
        if (this.workQueue.documentHasPendingOperationsOfType(documentKey, 3)) {
            return;
        }
        WorkQueueItem item = new WorkQueueItem(-1L);
        item.setDocumentKey(documentKey);
        item.setOperation(3);
        this.workQueue.queueNewWorkItem(item);
    }

    private void copyData(InputStream input, OutputStream output) throws IOException {
        int len;
        this.logger.debug("copyData(%s, %s)", new Object[]{input, output});
        byte[] buff = new byte[4096];
        while ((len = input.read(buff)) > 0) {
            output.write(buff, 0, len);
        }
    }
}

