/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.documents.box.actions;

import com.google.inject.Injector;
import io.intino.alexandria.Context;
import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.goros.documents.box.actions.Action;
import io.intino.goros.documents.box.services.Response;
import java.util.HashMap;
import java.util.Map;
import org.monet.docservice.core.log.Logger;
import org.monet.docservice.guice.InjectorFactory;
import org.monet.docservice.servlet.factory.ActionFactory;

public class DocumentAction
extends Action {
    public String documentCode;
    public String documentReferenced;
    public String destinationDocumentId;
    public String signature;
    public String signField;
    public Resource templateData;
    public String copiedDocumentCode;
    public String certificate;
    public String templateCode;
    public String mimeType;
    public Resource documentData;
    public String signId;
    public String signFields;
    public String asynchronous;
    public String action;
    public String contentType;
    public String sourceDocumentId;
    public String height;
    public String signReason;
    public String generatePreview;
    public String nodeCode;
    public String signsPosition;
    public String signLocation;
    public String signsCount;
    public String signContact;
    public String width;
    public String signsCountPattern;
    public String documentXmlData;
    public String documentId;
    public String label;
    public String space;
    private Logger logger;
    private ActionFactory actionsFactory;

    public DocumentAction() {
        Injector injector = InjectorFactory.get();
        this.logger = (Logger)injector.getInstance(Logger.class);
        this.actionsFactory = (ActionFactory)injector.getInstance(ActionFactory.class);
    }

    public Resource execute() throws BadRequest {
        try {
            this.response = new Response((Context)this.context);
            Map<String, Object> params = this.parametersToMap();
            String actionName = (String)params.get("action");
            this.logger.info("Controller.doProcess(%s)", new Object[]{actionName});
            org.monet.docservice.servlet.factory.impl.Action action = (org.monet.docservice.servlet.factory.impl.Action)this.actionsFactory.create((Object)actionName);
            if (action != null) {
                action.execute(params, (org.monet.http.Response)this.response);
            } else {
                this.logger.info("Action(%s) not found", new Object[]{actionName});
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BadRequest(e.getMessage());
        }
        return this.resource();
    }

    private Map<String, Object> parametersToMap() {
        return new HashMap<String, Object>(){
            {
                this.put("documentCode", DocumentAction.this.documentCode);
                this.put("documentReferenced", DocumentAction.this.documentReferenced);
                this.put("destinationDocumentId", DocumentAction.this.destinationDocumentId);
                this.put("signature", DocumentAction.this.signature);
                this.put("signField", DocumentAction.this.signField);
                this.put("templateData", DocumentAction.this.templateData != null ? DocumentAction.this.templateData.stream() : null);
                this.put("copiedDocumentCode", DocumentAction.this.copiedDocumentCode);
                this.put("certificate", DocumentAction.this.certificate);
                this.put("templateCode", DocumentAction.this.templateCode);
                this.put("mimeType", DocumentAction.this.mimeType);
                this.put("documentData", DocumentAction.this.documentData != null ? DocumentAction.this.documentData.stream() : null);
                this.put("signId", DocumentAction.this.signId);
                this.put("signFields", DocumentAction.this.signFields);
                this.put("asynchronous", DocumentAction.this.asynchronous);
                this.put("action", DocumentAction.this.action);
                this.put("contentType", DocumentAction.this.contentType);
                this.put("sourceDocumentId", DocumentAction.this.sourceDocumentId);
                this.put("height", DocumentAction.this.height);
                this.put("signReason", DocumentAction.this.signReason);
                this.put("generatePreview", DocumentAction.this.generatePreview);
                this.put("nodeCode", DocumentAction.this.nodeCode);
                this.put("signsPosition", DocumentAction.this.signsPosition);
                this.put("signLocation", DocumentAction.this.signLocation);
                this.put("signsCount", DocumentAction.this.signsCount);
                this.put("signContact", DocumentAction.this.signContact);
                this.put("width", DocumentAction.this.width);
                this.put("signsCountPattern", DocumentAction.this.signsCountPattern);
                this.put("documentXmlData", DocumentAction.this.documentXmlData);
                this.put("documentId", DocumentAction.this.documentId);
                this.put("label", DocumentAction.this.label);
                this.put("space", DocumentAction.this.space);
            }
        };
    }
}

