/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.documents.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.goros.documents.box.DocserviceService;
import io.intino.goros.documents.box.DocumentsBox;
import io.intino.goros.documents.box.DocumentsConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends Box {
    protected DocumentsConfiguration configuration;

    public AbstractBox(String[] args) {
        this(new DocumentsConfiguration(args));
    }

    public AbstractBox(DocumentsConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public DocumentsConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public void stopServices() {
        AlexandriaSparkBuilder.instance().stop();
    }

    public abstract void afterStop();

    public void startServices() {
        this.initUI();
        this.initConnector();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
    }

    private void initRestServices() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaSparkBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/");
        DocserviceService.setup(AlexandriaSparkBuilder.instance(), (DocumentsBox)this);
        AlexandriaSparkBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service docservice: started at port " + this.configuration().get("port") + "!"));
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
    }

    private void initDatalake() {
    }

    private void initConnector() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
    }

    private void initWorkflow() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

