/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.util.time;

import io.intino.gamification.util.time.Scale;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    private static String timeZone = "Atlantic/Canary";

    public static void timeZone(String timeZone) {
        TimeUtils.timeZone = timeZone;
    }

    public static String timeZone() {
        return timeZone;
    }

    public static Instant currentInstant() {
        return TimeUtils.getInstantOf(TimeUtils.getZonedDateTimeOf());
    }

    public static Date dateOf(Instant instant) {
        return new Date(instant.toEpochMilli());
    }

    public static Instant getInstantOf(int year, int month, int day, int hour, int minute, int second, int millis) {
        return TimeUtils.getInstantOf(TimeUtils.getLocalDateTimeOf(year, month, day, hour, minute, second, millis));
    }

    public static Instant getInstantOf(int year, int month, int day, int hour, int minute, int second) {
        return TimeUtils.getInstantOf(year, month, day, hour, minute, second, 0);
    }

    public static Instant getInstantOf(int year, int month, int day, int hour, int minute) {
        return TimeUtils.getInstantOf(year, month, day, hour, minute, 0);
    }

    public static Instant getInstantOf(int year, int month, int day, int hour) {
        return TimeUtils.getInstantOf(year, month, day, hour, 0);
    }

    public static Instant getInstantOf(int year, int month, int day) {
        return TimeUtils.getInstantOf(year, month, day, 0);
    }

    public static Instant getInstantOf(int year, int month) {
        return TimeUtils.getInstantOf(year, month, 1);
    }

    public static Instant getInstantOf(int year) {
        if (year < 0) {
            return null;
        }
        return TimeUtils.getInstantOf(year, 1);
    }

    public static int secondOf(Instant instant) {
        return TimeUtils.getLocalDateTimeOf(instant).getSecond();
    }

    public static int minuteOf(Instant instant) {
        return TimeUtils.getLocalDateTimeOf(instant).getMinute();
    }

    public static int hourOf(Instant instant) {
        return TimeUtils.getLocalDateTimeOf(instant).getHour();
    }

    public static int weekDayOf(Instant instant) {
        return TimeUtils.getLocalDateTimeOf(instant).getDayOfWeek().getValue();
    }

    public static int monthDayOf(Instant instant) {
        return TimeUtils.getLocalDateTimeOf(instant).getDayOfMonth();
    }

    public static int monthOf(Instant instant) {
        return TimeUtils.getLocalDateTimeOf(instant).getMonth().getValue();
    }

    public static int yearOf(Instant instant) {
        return TimeUtils.getLocalDateTimeOf(instant).getYear();
    }

    public static Instant truncateTo(Instant instant, Scale scale) {
        if (scale.equals((Object)Scale.Millis)) {
            return instant.truncatedTo(ChronoUnit.MILLIS);
        }
        if (scale.equals((Object)Scale.Second)) {
            return instant.truncatedTo(ChronoUnit.SECONDS);
        }
        if (scale.equals((Object)Scale.Minute)) {
            return instant.truncatedTo(ChronoUnit.MINUTES);
        }
        if (scale.equals((Object)Scale.Hour)) {
            return instant.truncatedTo(ChronoUnit.HOURS);
        }
        if (scale.equals((Object)Scale.Day)) {
            return instant.truncatedTo(ChronoUnit.DAYS);
        }
        if (scale.equals((Object)Scale.Week)) {
            return TimeUtils.truncateToWeek(instant);
        }
        if (scale.equals((Object)Scale.Month)) {
            return TimeUtils.truncateToMonth(instant);
        }
        if (scale.equals((Object)Scale.Year)) {
            return TimeUtils.truncateToYear(instant);
        }
        return instant;
    }

    public static Instant previousInstant(Instant instant, Scale scale) {
        return TimeUtils.previousInstant(instant, scale, 1);
    }

    public static Instant previousInstant(Instant instant, Scale scale, int n) {
        if (scale.equals((Object)Scale.Millis)) {
            return instant.minus(n, ChronoUnit.MILLIS);
        }
        if (scale.equals((Object)Scale.Second)) {
            return instant.minus(n, ChronoUnit.SECONDS);
        }
        if (scale.equals((Object)Scale.Minute)) {
            return instant.minus(n, ChronoUnit.MINUTES);
        }
        if (scale.equals((Object)Scale.Hour)) {
            return instant.minus(n, ChronoUnit.HOURS);
        }
        if (scale.equals((Object)Scale.Day)) {
            return instant.minus(n, ChronoUnit.DAYS);
        }
        if (scale.equals((Object)Scale.Week)) {
            return instant.minus(7L * (long)n, ChronoUnit.DAYS);
        }
        if (scale.equals((Object)Scale.Month)) {
            return TimeUtils.minusMonths(instant, n);
        }
        if (scale.equals((Object)Scale.Year)) {
            return TimeUtils.minusYears(instant, n);
        }
        return instant;
    }

    public static Instant nextInstant(Instant instant, Scale scale) {
        return TimeUtils.nextInstant(instant, scale, 1);
    }

    public static Instant nextInstant(Instant instant, Scale scale, int n) {
        if (scale.equals((Object)Scale.Millis)) {
            return instant.plus((long)n, ChronoUnit.MILLIS);
        }
        if (scale.equals((Object)Scale.Second)) {
            return instant.plus((long)n, ChronoUnit.SECONDS);
        }
        if (scale.equals((Object)Scale.Minute)) {
            return instant.plus((long)n, ChronoUnit.MINUTES);
        }
        if (scale.equals((Object)Scale.Hour)) {
            return instant.plus((long)n, ChronoUnit.HOURS);
        }
        if (scale.equals((Object)Scale.Day)) {
            return instant.plus((long)n, ChronoUnit.DAYS);
        }
        if (scale.equals((Object)Scale.Week)) {
            return instant.plus(7L * (long)n, ChronoUnit.DAYS);
        }
        if (scale.equals((Object)Scale.Month)) {
            return TimeUtils.plusMonths(instant, n);
        }
        if (scale.equals((Object)Scale.Year)) {
            return TimeUtils.plusYears(instant, n);
        }
        return instant;
    }

    public static long getMillisOf(Scale scale, int amount) {
        long millis = 0L;
        switch (scale) {
            case Millis: {
                millis = 1L;
                break;
            }
            case Second: {
                millis = 1000L;
                break;
            }
            case Minute: {
                millis = 60000L;
                break;
            }
            case Hour: {
                millis = 3600000L;
                break;
            }
            case Day: {
                millis = 86400000L;
                break;
            }
            case Week: {
                millis = 604800000L;
            }
        }
        return millis * (long)amount;
    }

    public static long getInstantDiff(Instant instant1, Instant instant2, Scale scale) {
        if (instant1 == null || instant2 == null) {
            return -1L;
        }
        long diffInSeconds = Math.abs(instant1.getEpochSecond() - instant2.getEpochSecond());
        return TimeUtils.timeUnitOf(scale).convert(diffInSeconds, TimeUnit.SECONDS);
    }

    private static TimeUnit timeUnitOf(Scale scale) {
        switch (scale) {
            case Day: {
                return TimeUnit.DAYS;
            }
            case Hour: {
                return TimeUnit.HOURS;
            }
            case Millis: {
                return TimeUnit.MILLISECONDS;
            }
            case Minute: {
                return TimeUnit.MINUTES;
            }
            case Second: {
                return TimeUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("La escala no est\u00e1 permitida");
    }

    public static boolean instantIsInRange(Instant instant, Instant from, Instant to) {
        return !instant.isBefore(from) && instant.isBefore(to);
    }

    private static Instant getInstantOf(ZonedDateTime zdt) {
        return Instant.parse(zdt.toString().split("Z|[+-]\\d*:")[0] + "Z");
    }

    private static Instant getInstantOf(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.toInstant(ZoneOffset.UTC);
    }

    private static ZonedDateTime getZonedDateTimeOf() {
        return ZonedDateTime.now(ZoneId.of(timeZone));
    }

    private static LocalDateTime getLocalDateTimeOf(Instant instant) {
        return LocalDateTime.of(TimeUtils.getYearOf(instant), TimeUtils.getMonthOf(instant), TimeUtils.getDayOf(instant), TimeUtils.getHourOf(instant), TimeUtils.getMinuteOf(instant), TimeUtils.getSecondOf(instant), TimeUtils.getMillisOf(instant));
    }

    private static LocalDateTime getLocalDateTimeOf(int year, int month, int day, int hour, int minute, int second, int millis) {
        try {
            return LocalDateTime.of(year, month, day, hour, minute);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int getYearOf(Instant instant) {
        return TimeUtils.getComponentOf(instant, ChronoUnit.YEARS);
    }

    private static int getMonthOf(Instant instant) {
        return TimeUtils.getComponentOf(instant, ChronoUnit.MONTHS);
    }

    private static int getDayOf(Instant instant) {
        return TimeUtils.getComponentOf(instant, ChronoUnit.DAYS);
    }

    private static int getHourOf(Instant instant) {
        return TimeUtils.getComponentOf(instant, ChronoUnit.HOURS);
    }

    private static int getMinuteOf(Instant instant) {
        return TimeUtils.getComponentOf(instant, ChronoUnit.MINUTES);
    }

    private static int getSecondOf(Instant instant) {
        return TimeUtils.getComponentOf(instant, ChronoUnit.SECONDS);
    }

    private static int getMillisOf(Instant instant) {
        return TimeUtils.getComponentOf(instant, ChronoUnit.MILLIS);
    }

    private static int getComponentOf(Instant instant, ChronoUnit unit) {
        String ret = "-1";
        if (unit.equals(ChronoUnit.YEARS)) {
            ret = instant.toString().split("[TZ]")[0].split("-")[0];
        }
        if (unit.equals(ChronoUnit.MONTHS)) {
            ret = instant.toString().split("[TZ]")[0].split("-")[1];
        }
        if (unit.equals(ChronoUnit.DAYS)) {
            ret = instant.toString().split("[TZ]")[0].split("-")[2];
        }
        if (unit.equals(ChronoUnit.HOURS)) {
            ret = instant.toString().split("[TZ]")[1].split(":")[0];
        }
        if (unit.equals(ChronoUnit.MINUTES)) {
            ret = instant.toString().split("[TZ]")[1].split(":")[1];
        }
        if (unit.equals(ChronoUnit.SECONDS)) {
            ret = String.valueOf((int)Float.parseFloat(instant.toString().split("[TZ]")[1].split(":")[2]));
        }
        if (unit.equals(ChronoUnit.MILLIS)) {
            ret = String.valueOf((int)(1000.0 * (Double.parseDouble(instant.toString().split("[TZ]")[1].split(":")[2]) % 1.0)));
        }
        return Integer.parseInt(ret);
    }

    private static Instant truncateToWeek(Instant instant) {
        Instant dayInstant = TimeUtils.truncateTo(instant, Scale.Day);
        int dayOfWeek = TimeUtils.weekDayOf(dayInstant);
        return TimeUtils.previousInstant(dayInstant, Scale.Day, dayOfWeek - 1);
    }

    private static Instant truncateToMonth(Instant instant) {
        return TimeUtils.getInstantOf(TimeUtils.yearOf(instant), TimeUtils.monthOf(instant));
    }

    private static Instant truncateToYear(Instant instant) {
        return TimeUtils.getInstantOf(TimeUtils.yearOf(instant));
    }

    private static Instant minusMonths(Instant instant, int nMonth) {
        return TimeUtils.offsetMonth(instant, -nMonth);
    }

    private static Instant plusMonths(Instant instant, int nMonth) {
        return TimeUtils.offsetMonth(instant, nMonth);
    }

    private static Instant offsetMonth(Instant instant, int nMonth) {
        int day = TimeUtils.monthDayOf(instant);
        int month = TimeUtils.monthOf(instant) + nMonth;
        int year = TimeUtils.yearOf(instant);
        while (month < 1) {
            month += 12;
            --year;
        }
        while (month > 12) {
            month -= 12;
            ++year;
        }
        day = TimeUtils.adjustedDay(day, month, year);
        return TimeUtils.getInstantOf(year, month, day, TimeUtils.hourOf(instant), TimeUtils.minuteOf(instant));
    }

    private static Instant minusYears(Instant instant, int nYears) {
        return TimeUtils.offsetYear(instant, -nYears);
    }

    private static Instant plusYears(Instant instant, int nYears) {
        return TimeUtils.offsetYear(instant, nYears);
    }

    private static Instant offsetYear(Instant instant, int nYears) {
        int day = TimeUtils.monthDayOf(instant);
        int year = TimeUtils.yearOf(instant) + nYears;
        day = TimeUtils.adjustedDay(day, TimeUtils.monthOf(instant), year);
        return TimeUtils.getInstantOf(year, TimeUtils.monthOf(instant), day, TimeUtils.hourOf(instant), TimeUtils.minuteOf(instant));
    }

    private static int adjustedDay(int day, int month, int year) {
        switch (month) {
            case 2: {
                return Math.min(day, TimeUtils.getFebruaryDaysOf(year));
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return Math.min(day, 30);
            }
        }
        return day;
    }

    private static int getFebruaryDaysOf(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? 29 : 28;
    }

    public static Instant toInstant(LocalDate date) {
        return TimeUtils.getInstantOf(date.getYear(), date.getMonth().getValue(), date.getDayOfMonth());
    }
}

