/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.util.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import io.intino.gamification.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public final class Json {
    public static String toJson(Object obj) {
        return Json.jsonSerializer().toJson(obj);
    }

    public static String toJsonPretty(Object obj) {
        return Json.jsonPrettySerializer().toJson(obj);
    }

    public static <T> T fromJson(Class<T> clazz, String json) {
        return Json.jsonPrettySerializer().fromJson(json, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T read(Class<T> clazz, File file) {
        try (BufferedReader fileReader = new BufferedReader(new FileReader(file));){
            T t = Json.jsonPrettySerializer().fromJson((Reader)fileReader, clazz);
            return t;
        }
        catch (Exception e) {
            Log.error(e);
            return null;
        }
    }

    public static void write(Object obj, File file) {
        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));){
            Json.jsonPrettySerializer().toJson(obj, obj.getClass(), new JsonWriter(fileWriter));
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    private static Gson jsonSerializer() {
        return new Gson();
    }

    private static Gson jsonPrettySerializer() {
        return new GsonBuilder().setPrettyPrinting().create();
    }
}

