/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.util.file;

import io.intino.gamification.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FileUtils {
    public static File createFile(String filePath) {
        File file = new File(filePath);
        FileUtils.createFolder(file.getParentFile().getAbsolutePath());
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.error(e);
            }
        }
        return file;
    }

    public static File createFolder(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public static Object readObject(File file) {
        Object object;
        ObjectInputStream reader = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            object = reader.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Log.error(e);
                return null;
            }
        }
        reader.close();
        return object;
    }

    public static void writeObject(File file, Object object) {
        try (ObjectOutputStream writer = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            writer.writeObject(object);
        }
        catch (Exception e) {
            Log.error(e);
        }
    }
}

