/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.util.data;

import io.intino.gamification.graph.structure.Property;
import io.intino.gamification.graph.structure.ReadOnlyProperty;
import io.intino.gamification.util.Log;
import java.io.Serializable;

public final class Progress
implements Serializable {
    private final int total;
    private final Property<Integer> current;
    private boolean failed;

    public Progress(int total) {
        this(total, 0);
    }

    public Progress(int total, int current) {
        if (total <= 0) {
            IllegalArgumentException e = new IllegalArgumentException("Total must be > 0");
            Log.error(e);
            throw e;
        }
        this.total = total;
        this.current = new Property();
        this.current.set(Math.min(total, current));
        this.failed = false;
    }

    public float get() {
        return (float)((Integer)this.current.get()).intValue() / (float)this.total;
    }

    public Progress set(int current) {
        if (this.state() == State.InProgress) {
            this.current.set(Math.min(this.total, current));
        }
        return this;
    }

    public Progress increment() {
        return this.set((Integer)this.current.get() + 1);
    }

    public Progress fail() {
        this.failed = true;
        return this;
    }

    public Progress complete() {
        this.current.set(this.total);
        return this;
    }

    public State state() {
        if (this.isCompleted()) {
            return State.Complete;
        }
        if (!this.isFailed()) {
            return State.InProgress;
        }
        return State.Failed;
    }

    private boolean isCompleted() {
        return !this.failed && this.get() >= 1.0f;
    }

    private boolean isFailed() {
        return this.failed;
    }

    public int current() {
        return (Integer)this.current.get();
    }

    public ReadOnlyProperty<Integer> currentProperty() {
        return this.current;
    }

    public int total() {
        return this.total;
    }

    public static enum State {
        Complete,
        InProgress,
        Failed;

    }
}

