/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.util;

import io.intino.gamification.util.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class TypeUtils {
    public static <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T newInstance(Class<T> type, Object ... args) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(TypeUtils.classesOf(args));
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class[] classesOf(Object[] objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static void initSingleton(Class<?> clazz) {
        TypeUtils.initSingleton(clazz, TypeUtils.newInstance(clazz));
    }

    public static void initSingleton(Class<?> clazz, Object value) {
        TypeUtils.setAnnotatedField(clazz, Singleton.class, value);
    }

    public static void setAnnotatedField(Class<?> clazz, Class<? extends Annotation> annotation, Object value) {
        ((Stream)Stream.of(clazz.getDeclaredFields()).parallel()).filter(f -> Objects.nonNull(f.getAnnotation(annotation))).findAny().ifPresent(field -> {
            field.setAccessible(true);
            try {
                field.set(null, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    public static <T> T getAnnotatedField(Class<?> clazz, Class<? extends Annotation> annotation) {
        return ((Stream)Stream.of(clazz.getDeclaredFields()).parallel()).filter(f -> Objects.nonNull(f.getAnnotation(annotation))).findAny().orElse(null);
    }

    public static <T> T singleton(Class<?> clazz) {
        return TypeUtils.getAnnotatedField(clazz, Singleton.class);
    }

    public static <T> T callAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotation, Object object) {
        Optional<Method> result = ((Stream)Stream.of(clazz.getDeclaredMethods()).parallel()).filter(method -> Objects.nonNull(method.getDeclaredAnnotation(annotation))).findAny();
        if (result.isPresent()) {
            try {
                Method method2 = result.get();
                method2.setAccessible(true);
                return (T)method2.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> T getOrElse(T actual, T orElse) {
        return actual == null ? orElse : actual;
    }
}

