/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.structure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public abstract class ReadOnlyProperty<T>
implements Serializable {
    protected T value;
    protected transient List<Observer<T>> observers = new LinkedList<Observer<T>>();

    public ReadOnlyProperty() {
        this(null);
    }

    public ReadOnlyProperty(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public void addObserver(Observer<T> observer) {
        if (observer == null) {
            return;
        }
        this.observers.add(observer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.observers = new LinkedList<Observer<T>>();
    }

    @FunctionalInterface
    public static interface Observer<T> {
        public void onValueChanged(T var1, T var2);
    }
}

