/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.structure;

import io.intino.gamification.graph.structure.ReadOnlyProperty;
import java.util.Objects;

public class Property<T>
extends ReadOnlyProperty<T> {
    public Property() {
        this(null);
    }

    public Property(T value) {
        super(value);
    }

    public void set(T value) {
        Object oldValue = this.value;
        this.value = value;
        this.notifyObservers(oldValue, value);
    }

    public void bind(ReadOnlyProperty<T> other) {
        other.addObserver(this::onBoundPropertyChanged);
    }

    private void onBoundPropertyChanged(T oldValue, T newValue) {
        this.set(newValue);
    }

    private void notifyObservers(T oldValue, T newValue) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        this.observers.forEach(observer -> observer.onValueChanged(oldValue, newValue));
    }
}

