/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.GamificationGraph;
import io.intino.gamification.graph.model.Competition;
import io.intino.gamification.graph.model.MissionAssignment;
import io.intino.gamification.graph.model.Node;
import io.intino.gamification.graph.model.NodeCollection;
import io.intino.gamification.graph.model.PlayerState;
import io.intino.gamification.graph.model.Round;
import io.intino.gamification.util.time.TimeUtils;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Season
extends Node {
    private final NodeCollection<Round> rounds = new NodeCollection();
    private final NodeCollection<PlayerState> playerStates = new NodeCollection();
    private Instant startTime;
    private Instant endTime;
    private State state = State.Created;

    public Season(String id) {
        super(id);
    }

    @Override
    void init() {
        this.rounds.init(this.absoluteId());
        this.playerStates.init(this.absoluteId());
        this.startTime = Instant.now();
    }

    public final NodeCollection<Round> rounds() {
        return this.rounds;
    }

    public final NodeCollection<PlayerState> playerStates() {
        return this.playerStates;
    }

    public final State state() {
        return this.state;
    }

    public Season state(State state) {
        this.state = state;
        return this;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Season startTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Season endTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    @Override
    void destroyChildren() {
        this.rounds.forEach(Node::markAsDestroyed);
        this.playerStates.forEach(Node::markAsDestroyed);
    }

    public Competition competition() {
        return this.parent();
    }

    @Override
    public Competition parent() {
        String[] ids = this.parentIds();
        if (ids == null || ids.length == 0) {
            return null;
        }
        return (Competition)GamificationGraph.get().competitions().find(ids[0]);
    }

    void begin() {
        this.startTime = TimeUtils.currentInstant();
        this.onBegin();
        this.state = State.Running;
    }

    void end() {
        this.endTime = TimeUtils.currentInstant();
        this.endMissions();
        this.onEnd();
        this.state = State.Finished;
    }

    public final void startNewRound(Round round) {
        if (round != null) {
            this.rounds.add(round);
            round.begin();
        }
    }

    public final void finishCurrentRound() {
        Round currentRound = this.rounds.last();
        if (currentRound != null && currentRound.isAvailable()) {
            currentRound.end();
        }
    }

    public Round currentRound() {
        if (this.rounds.isEmpty()) {
            return null;
        }
        Round round = this.rounds.last();
        return round.state() == Round.State.Finished ? null : round;
    }

    public final List<PlayerState> persistencePlayerState() {
        return this.playerStates.stream().map(this::filter).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void endMissions() {
        this.playerStates.forEach(PlayerState::endMissions);
    }

    private PlayerState filter(PlayerState playerState) {
        PlayerState newPlayerState = playerState.copy();
        newPlayerState.missionAssignments().removeIf(this::endWithinThisSeason);
        if (newPlayerState.missionAssignments().size() == 0) {
            return null;
        }
        return newPlayerState;
    }

    boolean endWithinThisSeason(MissionAssignment missionAssignment) {
        return missionAssignment.hasExpired() || missionAssignment.expirationTime().endsWithMatch();
    }

    protected void onBegin() {
    }

    protected void onEnd() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Season season = (Season)o;
        return Objects.equals(this.rounds, season.rounds) && Objects.equals(this.playerStates, season.playerStates) && Objects.equals(this.startTime, season.startTime) && Objects.equals(this.endTime, season.endTime) && Objects.equals((Object)this.state, (Object)season.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.rounds, this.playerStates, this.startTime, this.endTime, this.state});
    }

    @Override
    public String toString() {
        return "Season{rounds=" + this.rounds + ", playerStates=" + this.playerStates + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", state=" + this.state + "}";
    }

    public static enum State {
        Created,
        Running,
        Finished;

    }
}

