/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.GamificationGraph;
import io.intino.gamification.graph.model.Competition;
import io.intino.gamification.graph.model.Fact;
import io.intino.gamification.graph.model.Node;
import io.intino.gamification.graph.model.NodeCollection;
import io.intino.gamification.graph.model.Season;
import io.intino.gamification.util.time.TimeUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Round
extends Node {
    private final NodeCollection<Match> matches = new NodeCollection();
    private Instant startTime;
    private Instant endTime;
    private State state = State.Created;

    public Round(String id) {
        super(id);
    }

    @Override
    void init() {
        this.matches.init(this.absoluteId());
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Round startTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Round endTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    public State state() {
        return this.state;
    }

    public Round state(State state) {
        this.state = state;
        return this;
    }

    public final NodeCollection<Match> matches() {
        return this.matches;
    }

    void begin() {
        this.startTime = TimeUtils.currentInstant();
        this.onBegin();
        this.state = State.Running;
    }

    void end() {
        this.endTime = TimeUtils.currentInstant();
        this.onEnd();
        this.state = State.Finished;
    }

    protected void onBegin() {
    }

    protected void onEnd() {
    }

    @Override
    void destroyChildren() {
        this.matches.forEach(Node::markAsDestroyed);
    }

    public Season season() {
        return this.parent();
    }

    @Override
    public Season parent() {
        String[] ids = this.parentIds();
        if (ids == null || ids.length == 0) {
            return null;
        }
        return (Season)((Competition)GamificationGraph.get().competitions().find(ids[0])).seasons().find(ids[1]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Round round = (Round)o;
        return Objects.equals(this.matches, round.matches) && Objects.equals(this.startTime, round.startTime) && Objects.equals(this.endTime, round.endTime) && Objects.equals((Object)this.state, (Object)round.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.matches, this.startTime, this.endTime, this.state});
    }

    @Override
    public String toString() {
        return "Round{matches=" + this.matches + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", state=" + this.state + "}";
    }

    public static class Match
    extends Node {
        private final List<Fact> facts = new ArrayList<Fact>();

        public Match(String playerId) {
            super(playerId);
        }

        public void addFact(Fact fact) {
            this.facts.add(fact);
        }

        public int score() {
            return this.facts.stream().mapToInt(Fact::value).sum();
        }

        public List<Fact> facts() {
            return Collections.unmodifiableList(this.facts);
        }

        public Round round() {
            return this.parent();
        }

        @Override
        public Round parent() {
            String[] ids = this.parentIds();
            return (Round)((Season)((Competition)GamificationGraph.get().competitions().find(ids[0])).seasons().find(ids[1])).rounds().find(ids[2]);
        }
    }

    public static enum State {
        Created,
        Running,
        Finished;

    }
}

