/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.GamificationGraph;
import io.intino.gamification.graph.model.Competition;
import io.intino.gamification.graph.model.Fact;
import io.intino.gamification.graph.model.MissionAssignment;
import io.intino.gamification.graph.model.Node;
import io.intino.gamification.graph.model.NodeCollection;
import io.intino.gamification.graph.model.Round;
import io.intino.gamification.graph.model.Season;
import io.intino.gamification.util.data.Progress;
import java.util.stream.Stream;

public class PlayerState
extends Node {
    private final NodeCollection<MissionAssignment> missionAssignments = new NodeCollection();

    PlayerState(String id) {
        super(id);
    }

    @Override
    void init() {
        this.missionAssignments.init(this.absoluteId());
    }

    public Stream<Fact> facts() {
        return this.parent().rounds().stream().filter(round -> round.state() == Round.State.Finished).flatMap(round -> ((Round.Match)round.matches().find(this.id())).facts().stream());
    }

    public Stream<Fact> rawFacts() {
        return this.parent().rounds().stream().flatMap(round -> ((Round.Match)round.matches().find(this.id())).facts().stream());
    }

    public int score() {
        return this.facts().mapToInt(Fact::value).sum();
    }

    public int rawScore() {
        return this.rawFacts().mapToInt(Fact::value).sum();
    }

    public final NodeCollection<MissionAssignment> missionAssignments() {
        return this.missionAssignments;
    }

    @Override
    void destroyChildren() {
        this.missionAssignments.forEach(Node::markAsDestroyed);
    }

    public Season season() {
        return this.parent();
    }

    @Override
    public Season parent() {
        String[] ids = this.parentIds();
        if (ids == null || ids.length == 0) {
            return null;
        }
        return (Season)((Competition)GamificationGraph.get().competitions().find(ids[0])).seasons().find(ids[1]);
    }

    public void assignMission(MissionAssignment missionAssignment) {
        if (missionAssignment == null) {
            throw new NullPointerException("MissionAssignment cannot be null");
        }
        this.missionAssignments.add(missionAssignment);
    }

    void failMission(String missionId) {
        this.missionAssignments.stream().filter(ma -> ma.missionId().equals(missionId)).forEach(MissionAssignment::fail);
    }

    void completeMission(String missionId) {
        this.missionAssignments.stream().filter(ma -> ma.missionId().equals(missionId)).forEach(MissionAssignment::complete);
    }

    void cancelMission(String missionId) {
        this.missionAssignments.removeIf(ma -> ma.missionId().equals(missionId) && ma.progress().state() == Progress.State.InProgress);
    }

    void endMissions() {
        this.missionAssignments.forEach(ma -> {
            if (this.parent().endWithinThisSeason((MissionAssignment)ma) && ma.progress().state() == Progress.State.InProgress) {
                ma.update(ma.progress().state());
                ma.progress().fail();
            }
        });
    }

    PlayerState copy() {
        PlayerState ps = new PlayerState(this.id());
        for (MissionAssignment missionAssignment : this.missionAssignments) {
            ps.missionAssignments.add(missionAssignment.copy());
        }
        return ps;
    }

    private Competition competition() {
        return this.parent().parent();
    }
}

