/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.model.Entity;
import io.intino.gamification.graph.model.MissionAssignment;
import io.intino.gamification.graph.model.PlayerState;
import io.intino.gamification.graph.model.Season;

public class Player
extends Entity {
    public Player(String id) {
        super(id);
    }

    public final void assignMission(MissionAssignment missionAssignment) {
        Season season = this.availableSeason();
        if (season != null) {
            ((PlayerState)season.playerStates().find(this.id())).assignMission(missionAssignment);
        }
    }

    public final void failMission(String missionId) {
        Season season = this.availableSeason();
        if (season != null) {
            ((PlayerState)season.playerStates().find(this.id())).failMission(missionId);
        }
    }

    public final void completeMission(String missionId) {
        Season season = this.availableSeason();
        if (season != null) {
            ((PlayerState)season.playerStates().find(this.id())).completeMission(missionId);
        }
    }

    public final void cancelMission(String missionId) {
        Season season = this.availableSeason();
        if (season != null) {
            ((PlayerState)season.playerStates().find(this.id())).cancelMission(missionId);
        }
    }

    private Season availableSeason() {
        if (!this.parent().isAvailable()) {
            return null;
        }
        Season season = this.parent().currentSeason();
        if (season == null || !season.isAvailable()) {
            return null;
        }
        return season;
    }
}

