/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.model.Node;
import io.intino.gamification.graph.structure.SerializableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class NodeCollection<T extends Node>
extends SerializableCollection
implements Iterable<T> {
    private String context;
    private final List<T> nodes = new ArrayList<T>();
    private final Map<String, T> lookupTable = new HashMap<String, T>();

    public synchronized void init(String context) {
        if (this.initialized()) {
            throw new IllegalStateException("NodeCollection has been already initialized");
        }
        this.context = Objects.requireNonNull(context);
    }

    public boolean initialized() {
        return this.context != null;
    }

    public synchronized boolean add(T node) {
        if (!this.meetPreconditions(node)) {
            return false;
        }
        ((Node)node).index = this.nodes.size();
        this.nodes.add(node);
        this.lookupTable.put(((Node)node).id(), node);
        ((Node)node).init();
        ((Node)node).onCreate();
        return true;
    }

    private boolean meetPreconditions(T node) {
        if (!this.initialized()) {
            throw new IllegalStateException("This collection is not initialized");
        }
        if (node == null) {
            return false;
        }
        if (this.exists(((Node)node).id())) {
            return false;
        }
        if (((Node)node).parent() != null) {
            return false;
        }
        ((Node)node).buildParents(this.context);
        return true;
    }

    public void addAll(Collection<? extends T> nodes) {
        nodes.forEach(this::add);
    }

    public T addIfNotExists(String key, Supplier<T> supplier) {
        if (!this.exists(key)) {
            this.add((Node)supplier.get());
        }
        return (T)this.find(key);
    }

    public synchronized void destroy(T node) {
        this.nodes.remove(((Node)node).index);
        this.destroyInternal(node);
    }

    public synchronized void removeIf(Predicate<T> predicate) {
        Iterator<T> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!predicate.test(node)) continue;
            iterator.remove();
            this.destroyInternal(node);
        }
    }

    private void destroyInternal(T node) {
        this.lookupTable.remove(((Node)node).id());
        ((Node)node).markAsDestroyed();
        ((Node)node).onDestroy();
        ((Node)node).index = Integer.MIN_VALUE;
    }

    public boolean exists(String id) {
        return this.lookupTable.containsKey(id);
    }

    public <E extends T> E find(String id) {
        return (E)((Node)this.lookupTable.get(id));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.nodes.size();
    }

    public T first() {
        return (T)(this.nodes.isEmpty() ? null : (Node)this.nodes.get(0));
    }

    public T last() {
        return (T)(this.nodes.isEmpty() ? null : (Node)this.nodes.get(this.nodes.size() - 1));
    }

    public T get(int index) {
        return (T)((Node)this.nodes.get(index));
    }

    public List<T> list() {
        return Collections.unmodifiableList(this.nodes);
    }

    public Stream<T> stream() {
        return this.lookupTable.values().stream();
    }

    public void sort(Comparator<T> comparator) {
        this.nodes.sort(comparator);
    }

    @Override
    public Iterator<T> iterator() {
        return this.lookupTable.values().iterator();
    }

    public boolean readOnly() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeCollection that = (NodeCollection)o;
        return this.context.equals(that.context) && this.nodes.equals(that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.nodes);
    }

    public String toString() {
        return "NodeCollection{context='" + this.context + "', nodes=" + this.nodes + "}";
    }

    public NodeCollection<T> asReadOnly() {
        return new NodeCollection<T>(){

            @Override
            public boolean readOnly() {
                return true;
            }

            @Override
            public synchronized boolean add(T node) {
                throw new UnsupportedOperationException("Collection is read only");
            }

            @Override
            public void addAll(Collection<? extends T> nodes) {
                throw new UnsupportedOperationException("Collection is read only");
            }

            @Override
            public T addIfNotExists(String key, Supplier<T> supplier) {
                throw new UnsupportedOperationException("Collection is read only");
            }

            @Override
            public synchronized void destroy(T node) {
                throw new UnsupportedOperationException("Collection is read only");
            }

            @Override
            public synchronized void removeIf(Predicate<T> predicate) {
                throw new UnsupportedOperationException("Collection is read only");
            }

            @Override
            public void sort(Comparator<T> comparator) {
                throw new UnsupportedOperationException("Collection is read only");
            }
        };
    }
}

