/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.util.Log;
import io.intino.gamification.util.serializer.Json;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;

public abstract class Node
implements Serializable {
    public static final String PARENT_SEPARATOR = "\\$";
    private final String id;
    private String[] parentIds = new String[0];
    private boolean enabled = true;
    private boolean destroyed = false;
    int index = Integer.MIN_VALUE;

    Node(String id) {
        if (id == null) {
            NullPointerException e = new NullPointerException("Id cannot be null");
            Log.error(e);
            throw e;
        }
        this.id = id;
        this.initTransientAttributes();
    }

    public final String id() {
        return this.id;
    }

    public final String absoluteId() {
        if (this.parentIds == null || this.parentIds.length == 0) {
            return this.id;
        }
        return String.join((CharSequence)PARENT_SEPARATOR, this.parentIds) + PARENT_SEPARATOR + this.id;
    }

    public final String[] parentIds() {
        return this.parentIds;
    }

    public final void buildParents(String parentId) {
        if (parentId == null || parentId.isBlank()) {
            return;
        }
        this.parentIds = parentId.split(PARENT_SEPARATOR);
    }

    public final boolean isAvailable() {
        return this.enabled && !this.destroyed;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final boolean destroyed() {
        return this.destroyed;
    }

    public final void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.onEnable();
    }

    public final void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.onDisable();
    }

    final void markAsDestroyed() {
        this.destroyed = true;
        this.destroyChildren();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientAttributes();
    }

    public abstract Node parent();

    void init() {
    }

    void destroyChildren() {
    }

    void initTransientAttributes() {
    }

    protected void onCreate() {
    }

    protected void onUpdate() {
    }

    protected void onDestroy() {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.id, node.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return Json.toJson(this);
    }
}

