/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.GamificationGraph;
import io.intino.gamification.graph.model.Competition;
import io.intino.gamification.graph.model.Mission;
import io.intino.gamification.graph.model.Node;
import io.intino.gamification.graph.model.PlayerState;
import io.intino.gamification.graph.model.Season;
import io.intino.gamification.util.data.Progress;
import io.intino.gamification.util.time.TimeUtils;
import java.time.Instant;
import java.util.function.Function;

public abstract class MissionAssignment
extends Node {
    private final String missionId;
    private final Progress progress;
    private final Instant creationTime;
    private final ExpirationTime expirationTime;
    private final Function<MissionAssignment, Integer> scoreFunction;

    protected MissionAssignment(String id, String missionId, int stepsToComplete, ExpirationTime expirationTime, Function<MissionAssignment, Integer> scoreFunction) {
        super(id);
        this.missionId = missionId;
        this.progress = this.initProgress(stepsToComplete);
        this.creationTime = TimeUtils.currentInstant();
        this.expirationTime = expirationTime;
        this.scoreFunction = scoreFunction;
    }

    protected MissionAssignment(String id, String missionId, Progress progress, Instant creationTime, ExpirationTime expirationTime, Function<MissionAssignment, Integer> scoreFunction) {
        super(id);
        this.missionId = missionId;
        this.progress = progress;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.scoreFunction = scoreFunction;
    }

    boolean hasExpired() {
        if (this.expirationTime == null) {
            return false;
        }
        return !this.expirationTime.isAfter(TimeUtils.currentInstant());
    }

    void update(Progress.State newState) {
        if (newState == Progress.State.Complete) {
            this.onMissionComplete();
        } else if (newState == Progress.State.Failed) {
            this.onMissionFail();
        } else if (newState == Progress.State.InProgress) {
            this.onMissionIncomplete();
        }
        this.onMissionEnd();
    }

    void fail() {
        if (this.progress().state() == Progress.State.InProgress) {
            this.progress.fail();
            this.update(Progress.State.Failed);
        }
    }

    void complete() {
        if (this.progress().state() == Progress.State.InProgress) {
            this.progress.complete();
            this.update(Progress.State.Complete);
        }
    }

    MissionAssignment copy() {
        MissionAssignment missionAssignment = this.getCopy();
        missionAssignment.progress.set(this.progress.current());
        return missionAssignment;
    }

    private Progress initProgress(int stepsToComplete) {
        Progress progress = new Progress(stepsToComplete);
        progress.currentProperty().addObserver(this::onProgressChange);
        return progress;
    }

    public final Mission mission() {
        return (Mission)this.parent().parent().parent().missions().find(this.missionId);
    }

    public final String missionId() {
        return this.missionId;
    }

    public final Progress progress() {
        return this.progress;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ExpirationTime expirationTime() {
        return this.expirationTime;
    }

    public Integer score() {
        return this.scoreFunction.apply(this);
    }

    public PlayerState player() {
        return this.parent();
    }

    @Override
    public PlayerState parent() {
        String[] ids = this.parentIds();
        if (ids == null || ids.length == 0) {
            return null;
        }
        return (PlayerState)((Season)((Competition)GamificationGraph.get().competitions().find(ids[0])).seasons().find(ids[1])).playerStates().find(ids[2]);
    }

    protected void onProgressChange(int oldValue, int newValue) {
    }

    protected void onMissionComplete() {
    }

    protected void onMissionFail() {
    }

    protected void onMissionIncomplete() {
    }

    protected void onMissionEnd() {
    }

    protected abstract MissionAssignment getCopy();

    public static class ExpirationTime {
        private final Instant instant;

        public ExpirationTime() {
            this(null);
        }

        public ExpirationTime(Instant instant) {
            this.instant = instant;
        }

        public Instant instant() {
            return this.instant;
        }

        public boolean endsWithMatch() {
            return this.instant == null;
        }

        public long getEpochSecond() {
            return this.instant == null ? 0L : this.instant.getEpochSecond();
        }

        public int compareTo(Instant otherInstant) {
            return this.instant == null && otherInstant == null ? 0 : -1;
        }

        public boolean isAfter(Instant otherInstant) {
            return this.instant != null && this.instant.isAfter(otherInstant);
        }

        public boolean isBefore(Instant otherInstant) {
            return this.instant != null && this.instant.isBefore(otherInstant);
        }

        public String toString() {
            return "ExpirationTime{instant=" + this.instant + ", endsWithMatch=" + this.endsWithMatch() + "}";
        }
    }
}

