/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import java.time.Instant;
import java.util.Objects;

public class Fact {
    private final Instant ts;
    private final Type type;
    private final String name;
    private final int value;

    public Fact(Instant ts, Type type, String name, int value) {
        this.ts = ts;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public Instant ts() {
        return this.ts;
    }

    public Type type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public int value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fact fact = (Fact)o;
        return Objects.equals(this.ts, fact.ts) && this.type.equals(fact.type) && Objects.equals(this.name, fact.name) && Objects.equals(this.value, fact.value);
    }

    public int hashCode() {
        return Objects.hash(this.ts, this.type, this.name, this.value);
    }

    public String toString() {
        return "Fact{ts=" + this.ts + ", type=" + this.type + ", name='" + this.name + "', value=" + this.value + "}";
    }

    public static class Type {
        private final String name;

        public Type(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type type = (Type)o;
            return Objects.equals(this.name, type.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

