/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.model.Achievement;
import io.intino.gamification.graph.model.Entity;
import io.intino.gamification.graph.model.Foul;
import io.intino.gamification.graph.model.Mission;
import io.intino.gamification.graph.model.Node;
import io.intino.gamification.graph.model.NodeCollection;
import io.intino.gamification.graph.model.Player;
import io.intino.gamification.graph.model.Season;
import io.intino.gamification.graph.model.Success;
import java.util.Objects;

public class Competition
extends Node {
    private final NodeCollection<Season> seasons = new NodeCollection();
    private final NodeCollection<Entity> entities = new NodeCollection();
    private final NodeCollection<Player> players = new NodeCollection();
    private final NodeCollection<Achievement> achievements = new NodeCollection();
    private final NodeCollection<Mission> missions = new NodeCollection();
    private final NodeCollection<Success> successes = new NodeCollection();
    private final NodeCollection<Foul> fouls = new NodeCollection();

    public Competition(String id) {
        super(id);
    }

    @Override
    void init() {
        this.seasons.init(this.absoluteId());
        this.entities.init(this.absoluteId());
        this.players.init(this.absoluteId());
        this.achievements.init(this.absoluteId());
        this.missions.init(this.absoluteId());
        this.successes.init(this.absoluteId());
        this.fouls.init(this.absoluteId());
    }

    public final NodeCollection<Season> seasons() {
        return this.seasons;
    }

    public final Season currentSeason() {
        if (this.seasons.isEmpty()) {
            return null;
        }
        Season season = this.seasons.last();
        return season.state() == Season.State.Finished ? null : season;
    }

    public final NodeCollection<Mission> missions() {
        return this.missions;
    }

    @Override
    void destroyChildren() {
        this.seasons.forEach(Node::markAsDestroyed);
        this.entities.forEach(Node::markAsDestroyed);
        this.players.forEach(Node::markAsDestroyed);
        this.achievements.forEach(Node::markAsDestroyed);
        this.missions.forEach(Node::markAsDestroyed);
    }

    @Override
    public Node parent() {
        return null;
    }

    public void startNewSeason(Season season) {
        if (season != null && this.currentSeason() == null) {
            this.seasons.add(season);
            season.begin();
        }
    }

    public void finishCurrentSeason() {
        Season currentSeason = this.currentSeason();
        if (currentSeason != null && currentSeason.isAvailable()) {
            currentSeason.end();
        }
    }

    public final NodeCollection<Player> players() {
        return this.players;
    }

    public NodeCollection<Entity> entities() {
        return this.entities;
    }

    public NodeCollection<Achievement> achievements() {
        return this.achievements;
    }

    public NodeCollection<Success> successes() {
        return this.successes;
    }

    public NodeCollection<Foul> fouls() {
        return this.fouls;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Competition that = (Competition)o;
        return Objects.equals(this.seasons, that.seasons) && Objects.equals(this.entities, that.entities) && Objects.equals(this.players, that.players) && Objects.equals(this.achievements, that.achievements) && Objects.equals(this.missions, that.missions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.seasons, this.entities, this.players, this.achievements, this.missions);
    }

    @Override
    public String toString() {
        return this.id();
    }
}

