/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph.model;

import io.intino.gamification.graph.GamificationGraph;
import io.intino.gamification.graph.model.Competition;
import io.intino.gamification.graph.model.Node;

public class Achievement
extends Node {
    private String description;
    private final Type type;

    public Achievement(String id, Type type) {
        super(id);
        this.type = type;
    }

    public Achievement(String id, Type type, String description) {
        super(id);
        this.type = type;
        this.description = description;
    }

    public String name() {
        return this.id();
    }

    public Type type() {
        return this.type;
    }

    public Achievement description(String description) {
        this.description = description;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Competition competition() {
        return this.parent();
    }

    @Override
    public Competition parent() {
        String[] ids = this.parentIds();
        if (ids == null || ids.length == 0) {
            return null;
        }
        return (Competition)GamificationGraph.get().competitions().find(ids[0]);
    }

    @Override
    public String toString() {
        return "Achievement{name=" + this.id() + "description='" + this.description + "'}";
    }

    public static enum Type {
        Mention,
        Milestone,
        Prize,
        Record;

    }
}

