/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.graph;

import io.intino.gamification.core.GamificationCore;
import io.intino.gamification.graph.model.Competition;
import io.intino.gamification.graph.model.NodeCollection;
import io.intino.gamification.util.Log;

public class GamificationGraph {
    private static volatile GamificationGraph instance;
    private final GamificationCore core;
    private final NodeCollection<Competition> competitions;

    public static GamificationGraph get() {
        return instance;
    }

    public GamificationGraph(GamificationCore core) {
        if (core == null) {
            IllegalArgumentException e = new IllegalArgumentException("GamificationCore cannot be null");
            Log.error(e);
            throw e;
        }
        this.core = core;
        this.competitions = new NodeCollection();
        this.competitions.init("");
        instance = this;
    }

    public NodeCollection<Competition> competitions() {
        return this.competitions;
    }

    public void save() {
        this.core.graphSerializer().save();
    }
}

