/*
 * Decompiled with CFR 0.152.
 */
package io.intino.gamification.core;

import io.intino.gamification.util.Log;
import java.util.Map;
import java.util.NoSuchElementException;

public class GamificationParameters {
    private final String timeZone;
    private final String gamificationPath;
    private final String gamificationDatamart;

    public GamificationParameters(Map<String, String> params) {
        this.timeZone = this.getOrElse(params, "gamification_time_zone");
        this.gamificationPath = this.getOrElse(params, "gamification_path");
        this.gamificationDatamart = this.getOrElse(params, "gamification_datamart");
    }

    public String timeZone() {
        return this.timeZone;
    }

    public String gamificationPath() {
        return this.gamificationPath;
    }

    public String gamificationDatamart() {
        return this.gamificationDatamart;
    }

    private String getOrElse(Map<String, String> params, String param) {
        if (!params.containsKey(param)) {
            NoSuchElementException e = new NoSuchElementException("Missing parameter " + param);
            Log.error(e);
            throw e;
        }
        return params.get(param);
    }

    public String toString() {
        return "GamificationParameters{timeZone='" + this.timeZone + "', gamificationPath='" + this.gamificationPath + "', gamificationDatamart='" + this.gamificationDatamart + "'}";
    }
}

