/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Message;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Sensor;
import io.intino.magritte.framework.Expression;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Namespace
extends Layer
implements Terminal {
    protected Expression<String> qn;
    protected List<Namespace> namespaceList = new ArrayList<Namespace>();
    protected List<Message> messageList = new ArrayList<Message>();
    protected List<Sensor> sensorList = new ArrayList<Sensor>();
    protected List<Resource> resourceList = new ArrayList<Resource>();

    public Namespace(Node node) {
        super(node);
    }

    public String qn() {
        return (String)this.qn.value();
    }

    public Namespace qn(Expression<String> value) {
        this.qn = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public List<Namespace> namespaceList() {
        return Collections.unmodifiableList(this.namespaceList);
    }

    public Namespace namespace(int index) {
        return this.namespaceList.get(index);
    }

    public List<Namespace> namespaceList(Predicate<Namespace> predicate) {
        return this.namespaceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Namespace namespace(Predicate<Namespace> predicate) {
        return this.namespaceList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Message> messageList() {
        return Collections.unmodifiableList(this.messageList);
    }

    public Message message(int index) {
        return this.messageList.get(index);
    }

    public List<Message> messageList(Predicate<Message> predicate) {
        return this.messageList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Message message(Predicate<Message> predicate) {
        return this.messageList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Sensor> sensorList() {
        return Collections.unmodifiableList(this.sensorList);
    }

    public Sensor sensor(int index) {
        return this.sensorList.get(index);
    }

    public List<Sensor> sensorList(Predicate<Sensor> predicate) {
        return this.sensorList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Sensor sensor(Predicate<Sensor> predicate) {
        return this.sensorList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Resource> resourceList() {
        return Collections.unmodifiableList(this.resourceList);
    }

    public Resource resource(int index) {
        return this.resourceList.get(index);
    }

    public List<Resource> resourceList(Predicate<Resource> predicate) {
        return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Resource resource(Predicate<Resource> predicate) {
        return this.resourceList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Namespace>(this.namespaceList).forEach(c -> components.add(c.core$()));
        new ArrayList<Message>(this.messageList).forEach(c -> components.add(c.core$()));
        new ArrayList<Sensor>(this.sensorList).forEach(c -> components.add(c.core$()));
        new ArrayList<Resource>(this.resourceList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("qn", new ArrayList<Expression<String>>(Collections.singletonList(this.qn)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Namespace")) {
            this.namespaceList.add((Namespace)node.as(Namespace.class));
        }
        if (node.is("Message")) {
            this.messageList.add((Message)node.as(Message.class));
        }
        if (node.is("Sensor")) {
            this.sensorList.add((Sensor)node.as(Sensor.class));
        }
        if (node.is("Resource")) {
            this.resourceList.add((Resource)node.as(Resource.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Namespace")) {
            this.namespaceList.remove(node.as(Namespace.class));
        }
        if (node.is("Message")) {
            this.messageList.remove(node.as(Message.class));
        }
        if (node.is("Sensor")) {
            this.sensorList.remove(node.as(Sensor.class));
        }
        if (node.is("Resource")) {
            this.resourceList.remove(node.as(Resource.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("qn")) {
            this.qn = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("qn")) {
            this.qn = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Namespace namespace() {
            Namespace newElement = (Namespace)Namespace.this.core$().graph().concept(Namespace.class).createNode(this.name, Namespace.this.core$()).as(Namespace.class);
            return newElement;
        }

        public Message message() {
            Message newElement = (Message)Namespace.this.core$().graph().concept(Message.class).createNode(this.name, Namespace.this.core$()).as(Message.class);
            return newElement;
        }

        public Sensor sensor() {
            Sensor newElement = (Sensor)Namespace.this.core$().graph().concept(Sensor.class).createNode(this.name, Namespace.this.core$()).as(Sensor.class);
            return newElement;
        }

        public Resource resource() {
            Resource newElement = (Resource)Namespace.this.core$().graph().concept(Resource.class).createNode(this.name, Namespace.this.core$()).as(Resource.class);
            return newElement;
        }
    }

    public class Clear {
        public void namespace(Predicate<Namespace> filter) {
            new ArrayList<Namespace>(Namespace.this.namespaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void message(Predicate<Message> filter) {
            new ArrayList<Message>(Namespace.this.messageList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void sensor(Predicate<Sensor> filter) {
            new ArrayList<Sensor>(Namespace.this.sensorList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void resource(Predicate<Resource> filter) {
            new ArrayList<Resource>(Namespace.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

