/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.ui;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.ui.UI;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.displays.requesters.DisplayPushRequester;
import io.intino.alexandria.ui.displays.requesters.TemplatePushRequester;
import io.intino.alexandria.ui.displays.requesters.TemplateRequester;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.spark.UIRouter;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.DataHubConfiguration;
import io.intino.datahub.box.ui.displays.HtmlViewer;
import io.intino.datahub.box.ui.displays.notifiers.HtmlViewerNotifier;
import io.intino.datahub.box.ui.displays.requesters.HtmlViewerPushRequester;
import io.intino.datahub.box.ui.displays.requesters.HtmlViewerRequester;
import io.intino.datahub.box.ui.displays.templates.Header;
import io.intino.datahub.box.ui.displays.templates.HomeTemplate;
import io.intino.datahub.box.ui.resources.HomeResource;

public class DatalakeInspectorService
extends UI {
    public static void init(UISpark spark, DataHubBox box, io.intino.alexandria.ui.services.push.PushService pushService, DisplayRouteDispatcher routeDispatcher) {
        DataHubConfiguration configuration = box.configuration();
        box.routeManager(DatalakeInspectorService.routeManager((UISpark)spark, (DisplayRouteDispatcher)routeDispatcher));
        ((UIRouter)spark.route("/push")).push((PushService)pushService);
        ((UIRouter)spark.route("/authenticate-callback")).get(manager -> new AuthenticateCallbackResource(manager, DatalakeInspectorService.notifierProvider()).execute());
        ((UIRouter)spark.route("/authenticate-callback/")).get(manager -> new AuthenticateCallbackResource(manager, DatalakeInspectorService.notifierProvider()).execute());
        ((UIRouter)spark.route("/asset/:name")).get(manager -> new AssetResource(name -> new AssetResourceLoader((Box)box).load(name), manager, DatalakeInspectorService.notifierProvider()).execute());
        ((UIRouter)spark.route("/")).get(manager -> new HomeResource(box, (UISparkManager)manager, DatalakeInspectorService.notifierProvider()).execute());
        DatalakeInspectorService.initDisplays(spark, pushService);
    }

    public static void initDisplays(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        DatalakeInspectorService.initHomeTemplate(spark, pushService);
        DatalakeInspectorService.initHeader(spark, pushService);
        DatalakeInspectorService.initHtmlViewer(spark, pushService);
        DatalakeInspectorService.registerNotifiers();
    }

    private static void registerNotifiers() {
        DatalakeInspectorService.register(TemplateNotifier.class).forDisplay(HomeTemplate.class);
        DatalakeInspectorService.register(TemplateNotifier.class).forDisplay(Header.class);
        DatalakeInspectorService.register(HtmlViewerNotifier.class).forDisplay(HtmlViewer.class);
    }

    private static void initHomeTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/hometemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/hometemplate/:displayId")).post(manager -> new TemplateRequester(manager, DatalakeInspectorService.notifierProvider()).execute());
        ((UIRouter)spark.route("/hometemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("hometemplate", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initHeader(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/header/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/header/:displayId")).post(manager -> new TemplateRequester(manager, DatalakeInspectorService.notifierProvider()).execute());
        ((UIRouter)spark.route("/header/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("header", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initHtmlViewer(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/htmlviewer/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/htmlviewer/:displayId")).post(manager -> new HtmlViewerRequester((UISparkManager)manager, DatalakeInspectorService.notifierProvider()).execute());
        ((UIRouter)spark.route("/htmlviewer/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("htmlviewer", (DisplayPushRequester)new HtmlViewerPushRequester());
    }
}

