/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.broker.jms;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Json;
import io.intino.alexandria.Resource;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.event.resource.ResourceEventWriter;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.broker.jms.JmsMessageTranslator;
import io.intino.datahub.datamart.MasterDatamartRepository;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.model.Datalake;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.jms.BytesMessage;

class JmsMessageSerializer {
    private final File stage;
    private final Datalake.Tank tank;
    private final Scale scale;
    private final MasterDatamartMounter[] mounters;

    JmsMessageSerializer(File stage, Datalake.Tank tank, Scale scale, MasterDatamartRepository datamarts) {
        this.stage = stage;
        this.tank = tank;
        this.scale = scale;
        this.mounters = JmsMessageSerializer.createMountersFor(tank, datamarts);
    }

    Consumer<javax.jms.Message> create() {
        if (this.tank.isMessage()) {
            return new MessageHandler();
        }
        if (this.tank.isMeasurement()) {
            return new MeasurementHandler();
        }
        if (this.tank.isResource()) {
            return new ResourceHandler();
        }
        return Handler.empty();
    }

    private Timetag timetag(Instant ts) {
        return Timetag.of((LocalDateTime)LocalDateTime.ofInstant(ts, ZoneOffset.UTC), (Scale)this.scale);
    }

    private static MasterDatamartMounter[] createMountersFor(Datalake.Tank tank, MasterDatamartRepository datamartsRepo) {
        return datamartsRepo == null ? new MasterDatamartMounter[]{} : (MasterDatamartMounter[])datamartsRepo.datamarts().stream().flatMap(datamart -> datamart.createMountersFor(tank)).toArray(MasterDatamartMounter[]::new);
    }

    private String withOutParameters(String ss) {
        return ss.contains("?") ? ss.substring(0, ss.indexOf("?")) : ss;
    }

    private class MessageHandler
    implements Handler {
        private MessageHandler() {
        }

        @Override
        public void accept(javax.jms.Message message) {
            this.consume(JmsMessageTranslator.toInlMessages(message));
        }

        private void consume(Iterator<Message> messages) {
            while (messages.hasNext()) {
                Message message = messages.next();
                this.save(message);
                this.mount(message);
            }
        }

        private void mount(Message message) {
            try {
                for (MasterDatamartMounter mounter : JmsMessageSerializer.this.mounters) {
                    mounter.mount(message);
                }
            }
            catch (Exception e) {
                Logger.error((String)("Error while mounting message of tank " + JmsMessageSerializer.this.tank.name$() + ": " + e.getMessage()), (Throwable)e);
            }
        }

        private void save(Message message) {
            this.write(this.destination(message).toPath(), message);
        }

        protected File destination(Message message) {
            MessageEvent event = new MessageEvent(message);
            String fingerprint = Fingerprint.of((String)JmsMessageSerializer.this.tank.qn(), (String)JmsMessageSerializer.this.withOutParameters(event.ss()), (Timetag)JmsMessageSerializer.this.timetag(event.ts()), (Event.Format)Event.Format.Message).name();
            return new File(JmsMessageSerializer.this.stage, fingerprint + ".session");
        }

        private void write(Path path, Message message) {
            try {
                Files.writeString(path, (CharSequence)(message.toString() + "\n\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    private class MeasurementHandler
    extends MessageHandler {
        private MeasurementHandler() {
        }

        @Override
        protected File destination(Message message) {
            MessageEvent event = new MessageEvent(message);
            String fingerprint = Fingerprint.of((String)JmsMessageSerializer.this.tank.qn(), (String)JmsMessageSerializer.this.withOutParameters(event.ss()), (Timetag)JmsMessageSerializer.this.timetag(event.ts()), (Event.Format)Event.Format.Measurement).name();
            return new File(JmsMessageSerializer.this.stage, fingerprint + ".session");
        }
    }

    private class ResourceHandler
    implements Handler {
        private ResourceHandler() {
        }

        @Override
        public void accept(javax.jms.Message message) {
            try {
                ResourceEvent event = this.readResourceEventFrom((BytesMessage)message);
                String fingerprint = Fingerprint.of((String)JmsMessageSerializer.this.tank.qn(), (String)JmsMessageSerializer.this.withOutParameters(event.ss()), (Timetag)JmsMessageSerializer.this.timetag(event.ts()), (Event.Format)Event.Format.Resource).name();
                File destination = new File(JmsMessageSerializer.this.stage, fingerprint + ".session");
                this.appendToDestinationFile(event, destination);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }

        private void appendToDestinationFile(ResourceEvent event, File destination) throws IOException {
            try (ResourceEventWriter writer = new ResourceEventWriter(destination, true);){
                writer.write((Event)event);
            }
        }

        private ResourceEvent readResourceEventFrom(BytesMessage m) throws Exception {
            String resourceName = m.getStringProperty("resource.name");
            Map metadata = (Map)Json.fromJson((String)m.getStringProperty("resource.metadata"), Map.class);
            int dataLength = m.getIntProperty("resource.data.length");
            byte[] data = new byte[dataLength];
            m.readBytes(data);
            Resource resource = new Resource(resourceName, data);
            resource.metadata().putAll(metadata);
            String type = m.getStringProperty("type");
            String ss = m.getStringProperty("ss");
            Instant ts = Instant.ofEpochMilli(m.getLongProperty("ts"));
            return new ResourceEvent(type, ss, resource).ts(ts);
        }
    }

    private static interface Handler
    extends Consumer<javax.jms.Message> {
        public static Handler empty() {
            return m -> {};
        }
    }
}

