/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.service.jms;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.jms.MessageReader;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;

public class DatamartsRequest {
    private final DataHubBox box;

    public DatamartsRequest(DataHubBox box) {
        this.box = box;
    }

    public Stream<javax.jms.Message> accept(javax.jms.Message request) {
        try {
            String content = MessageReader.textFrom((javax.jms.Message)request);
            return this.handleDatamartDownload(content);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return this.errorMessage(e.getMessage());
        }
    }

    private Stream<javax.jms.Message> handleDatamartDownload(String request) {
        Map<String, String> args = this.parseArgumentsFrom(request);
        String datamartName = args.get("datamart");
        MasterDatamart datamart = this.box.datamarts().get(datamartName);
        if (datamart == null) {
            String message = "Datamart " + datamartName + " not found";
            Logger.error((String)message);
            return this.errorMessage(message);
        }
        return switch (args.get("operation")) {
            case "snapshots" -> this.listAvailableSnapshotsOf(datamart);
            case "entities" -> this.downloadEntities(datamart, args);
            case "list-timelines" -> this.listTimelineFiles(datamart, args);
            case "get-timeline" -> this.getTimeline(datamart, args);
            case "list-reels" -> this.listReelFiles(datamart, args);
            case "get-reel" -> this.getReel(datamart, args);
            default -> this.errorMessage("Operation " + args.get("operation") + " not found");
        };
    }

    private Stream<javax.jms.Message> getReel(MasterDatamart datamart, Map<String, String> args) {
        return this.getChronos(args, this.box.datamartReelsDirectory(datamart.name(), args.get("type")), ".reel");
    }

    private Stream<javax.jms.Message> getTimeline(MasterDatamart datamart, Map<String, String> args) {
        return this.getChronos(args, this.box.datamartTimelinesDirectory(datamart.name()), ".timeline");
    }

    private Stream<javax.jms.Message> getChronos(Map<String, String> args, File dir, String extension) {
        String id = args.get("id");
        if (id == null) {
            String message = "Chronos object download requested but id argument not found";
            Logger.error((String)message);
            return this.errorMessage(message);
        }
        String type = args.get("type");
        if (type == null) {
            String message = "Chronos object download requested but type argument not found";
            Logger.error((String)message);
            return this.errorMessage(message);
        }
        File file = new File(dir, type + File.separator + id + extension);
        if (!file.exists()) {
            return this.errorMessage("Reel File not found");
        }
        String mode = args.getOrDefault("mode", "download");
        return mode.equals("path") ? this.path(file) : this.download(file);
    }

    private Stream<javax.jms.Message> errorMessage(String errorDescription) {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        try {
            message.setBooleanProperty("success", false);
            message.setText(errorDescription);
            return Stream.of(message);
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return Stream.of(message);
        }
    }

    private Stream<javax.jms.Message> download(File file) {
        try {
            ActiveMQBytesMessage message = new ActiveMQBytesMessage();
            byte[] bytes = Files.readAllBytes(file.toPath());
            message.setProperty("name", (Object)file.getName());
            message.setBooleanProperty("success", true);
            message.setIntProperty("size", bytes.length);
            message.writeBytes(bytes);
            message.compress();
            return Stream.of(message);
        }
        catch (Exception e) {
            return this.errorMessage("Could not send file " + file.getAbsolutePath() + ": " + e.getMessage());
        }
    }

    private Stream<javax.jms.Message> path(File file) {
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setBooleanProperty("success", true);
            message.setText(file.getAbsolutePath());
            return Stream.of(message);
        }
        catch (Exception e) {
            String message = "Could not send file path " + file.getAbsolutePath() + ": " + e.getMessage();
            Logger.error((String)message, (Throwable)e);
            return this.errorMessage(message);
        }
    }

    private Stream<javax.jms.Message> listReelFiles(MasterDatamart datamart, Map<String, String> args) {
        return this.listFiles(datamart.name(), this.box.datamartReelFiles(datamart.name(), args.get("id"), args.get("type")));
    }

    private Stream<javax.jms.Message> listTimelineFiles(MasterDatamart datamart, Map<String, String> args) {
        return this.listFiles(datamart.name(), this.box.datamartTimelineFiles(datamart.name(), args.get("id")));
    }

    private Stream<javax.jms.Message> listFiles(String datamart, List<File> files) {
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setBooleanProperty("success", true);
            message.setText(files.stream().map(File::getAbsolutePath).collect(Collectors.joining(",")));
            message.setIntProperty("count", files.size());
            return Stream.of(message);
        }
        catch (Exception e) {
            String message = "Could not list chronos files of " + datamart + ": " + e.getMessage();
            Logger.error((String)message, (Throwable)e);
            return this.errorMessage(message);
        }
    }

    private Stream<javax.jms.Message> downloadEntities(MasterDatamart datamart, Map<String, String> args) {
        Optional<String> timetag = Optional.ofNullable(args.get("timetag"));
        return timetag.map(s -> this.box.datamartSerializer().loadMostRecentSnapshotTo(datamart.name(), this.asTimetag((String)s)).map(MasterDatamart.Snapshot::datamart).map(d -> this.downloadEntities((MasterDatamart)d, (String)args.get("sourceSelector"))).orElse(Stream.empty())).orElseGet(() -> datamart == null ? this.errorMessage("Datamart not found") : this.downloadEntities(datamart, (String)args.get("sourceSelector")));
    }

    private Timetag asTimetag(String timetag) {
        return timetag.isEmpty() ? Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day) : Timetag.of((String)timetag);
    }

    private Stream<javax.jms.Message> listAvailableSnapshotsOf(MasterDatamart datamart) {
        List<Timetag> snapshots = this.box.datamartSerializer().listAvailableSnapshotsOf(datamart.name());
        if (snapshots.isEmpty()) {
            return Stream.empty();
        }
        try {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            message.setBooleanProperty("success", true);
            message.setIntProperty("count", snapshots.size());
            message.setText(snapshots.stream().map(Timetag::value).collect(Collectors.joining(",")));
            return Stream.of(message);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return this.errorMessage(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<javax.jms.Message> downloadEntities(MasterDatamart datamart, String sourceSelector) {
        MasterDatamart masterDatamart = datamart;
        synchronized (masterDatamart) {
            try {
                ActiveMQBytesMessage message = new ActiveMQBytesMessage();
                message.setBooleanProperty("success", true);
                Predicate<Message> messagePredicate = DatamartsRequest.predicateOf(sourceSelector);
                message.setIntProperty("count", sourceSelector != null ? datamart.entityStore().size() : DatamartsRequest.filtered(datamart, messagePredicate));
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16384);
                this.box.datamartSerializer().serialize(datamart, messagePredicate, outputStream);
                byte[] bytes = outputStream.toByteArray();
                message.writeBytes(bytes);
                message.setIntProperty("size", bytes.length);
                return Stream.of(message);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                return this.errorMessage(e.getMessage());
            }
        }
    }

    private static int filtered(MasterDatamart datamart, Predicate<Message> messagePredicate) {
        return (int)datamart.entityStore().stream().filter(messagePredicate).count();
    }

    private static Predicate<Message> predicateOf(String sqlSelector) {
        try {
            if (sqlSelector == null || sqlSelector.trim().isEmpty()) {
                return m -> true;
            }
            BooleanExpression expression = SelectorParser.parse((String)sqlSelector);
            return message -> {
                try {
                    MessageEvaluationContext context = new MessageEvaluationContext();
                    context.setMessageReference(DatamartsRequest.map(message));
                    return expression.matches(context);
                }
                catch (JMSException e) {
                    Logger.error((Throwable)e);
                    return false;
                }
            };
        }
        catch (InvalidSelectorException e) {
            Logger.error((Throwable)e);
            return m -> true;
        }
    }

    private static MessageReference map(Message message) {
        try {
            ActiveMQMessage amqMessage = new ActiveMQMessage();
            amqMessage.setBooleanProperty("success", true);
            amqMessage.setStringProperty("type", message.type());
            String ss = (String)message.get("ss").orElse(String.class, null);
            if (ss != null) {
                amqMessage.setStringProperty("ss", ss);
            }
            return amqMessage;
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private Map<String, String> parseArgumentsFrom(String request) {
        String[] command = request.split(";", -1);
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(command.length - 1);
        for (String argument : command) {
            String[] entry = argument.split("=", 2);
            if (entry.length < 2) continue;
            args.put(entry[0].trim(), entry[1].trim());
        }
        return args;
    }
}

