/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.jmx;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.actions.BackupAction;
import io.intino.datahub.box.actions.MappersAction;
import io.intino.datahub.box.actions.RecreateDatamartAction;
import io.intino.datahub.box.actions.RestoreDatalakeAction;
import io.intino.datahub.box.actions.ReviewAction;
import io.intino.datahub.box.actions.ReviseAction;
import io.intino.datahub.box.actions.SealAction;
import io.intino.datahub.box.actions.TanksAction;
import io.intino.datahub.box.jmx.ServiceMBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Service
implements ServiceMBean {
    private final DataHubBox box;

    @Override
    public List<String> help() {
        ArrayList<String> operations = new ArrayList<String>();
        operations.addAll(Arrays.asList("String tanks(): Show tanks", "String backup(): Launch datalake and datahub backup on demand", "String seal(): Launch datalake sealing", "String restoreDatalake(String timetag): Restore datalake to timetag parameter. Timetag is in scale of days", "String recreateDatamart(String datamartName): Recreate datamart", "String mappers(): Shows a list of available mappers", "String review(String mapper): Review datalake using a defined mapper. Returns a file containing the efects of passing the mapper", "String revise(String mapper): Review datalake using a defined mapper"));
        return operations;
    }

    public Service(DataHubBox box) {
        this.box = box;
    }

    @Override
    public String tanks() {
        try {
            TanksAction action = new TanksAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String backup() {
        try {
            BackupAction action = new BackupAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String seal() {
        try {
            SealAction action = new SealAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String restoreDatalake(String timetag) {
        try {
            RestoreDatalakeAction action = new RestoreDatalakeAction();
            action.box = this.box;
            action.timetag = timetag;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String recreateDatamart(String datamartName) {
        try {
            RecreateDatamartAction action = new RecreateDatamartAction();
            action.box = this.box;
            action.datamartName = datamartName;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String mappers() {
        try {
            MappersAction action = new MappersAction();
            action.box = this.box;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String review(String mapper) {
        try {
            ReviewAction action = new ReviewAction();
            action.box = this.box;
            action.mapper = mapper;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }

    @Override
    public String revise(String mapper) {
        try {
            ReviseAction action = new ReviseAction();
            action.box = this.box;
            action.mapper = mapper;
            return action.execute();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw e;
        }
    }
}

