/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Sensor;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Timeline
extends Layer
implements Component,
Terminal {
    protected Datalake.Tank.Measurement tank;
    protected Entity entity;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();

    public Timeline(Node node) {
        super(node);
    }

    public Datalake.Tank.Measurement tank() {
        return this.tank;
    }

    public Entity entity() {
        return this.entity;
    }

    public Timeline tank(Datalake.Tank.Measurement value) {
        this.tank = value;
        return this;
    }

    public Timeline entity(Entity value) {
        this.entity = value;
        return this;
    }

    public List<Attribute> attributeList() {
        return Collections.unmodifiableList(this.attributeList);
    }

    public Attribute attribute(int index) {
        return this.attributeList.get(index);
    }

    public List<Attribute> attributeList(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Attribute attribute(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("tank", this.tank != null ? new ArrayList<Datalake.Tank.Measurement>(Collections.singletonList(this.tank)) : Collections.emptyList());
        map.put("entity", this.entity != null ? new ArrayList<Entity>(Collections.singletonList(this.entity)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Timeline$Attribute")) {
            this.attributeList.add((Attribute)node.as(Attribute.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Timeline$Attribute")) {
            this.attributeList.remove(node.as(Attribute.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("tank")) {
            this.tank = (Datalake.Tank.Measurement)((Object)NodeLoader.load(values, Datalake.Tank.Measurement.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("entity")) {
            this.entity = (Entity)((Object)NodeLoader.load(values, Entity.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("tank")) {
            this.tank = values.get(0) != null ? (Datalake.Tank.Measurement)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Datalake.Tank.Measurement.class) : null;
        } else if (name.equalsIgnoreCase("entity")) {
            this.entity = values.get(0) != null ? (Entity)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Entity.class) : null;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class Attribute
    extends Layer
    implements Terminal {
        protected Sensor.Magnitude magnitude;
        protected Entity.Attribute from;

        public Attribute(Node node) {
            super(node);
        }

        public Sensor.Magnitude magnitude() {
            return this.magnitude;
        }

        public Entity.Attribute from() {
            return this.from;
        }

        public Attribute magnitude(Sensor.Magnitude value) {
            this.magnitude = value;
            return this;
        }

        public Attribute from(Entity.Attribute value) {
            this.from = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("magnitude", this.magnitude != null ? new ArrayList<Sensor.Magnitude>(Collections.singletonList(this.magnitude)) : Collections.emptyList());
            map.put("from", this.from != null ? new ArrayList<Entity.Attribute>(Collections.singletonList(this.from)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("magnitude")) {
                this.magnitude = (Sensor.Magnitude)((Object)NodeLoader.load(values, Sensor.Magnitude.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("from")) {
                this.from = (Entity.Attribute)((Object)NodeLoader.load(values, Entity.Attribute.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("magnitude")) {
                this.magnitude = values.get(0) != null ? (Sensor.Magnitude)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Sensor.Magnitude.class) : null;
            } else if (name.equalsIgnoreCase("from")) {
                this.from = values.get(0) != null ? (Entity.Attribute)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Entity.Attribute.class) : null;
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Attribute attribute(Sensor.Magnitude magnitude, Entity.Attribute from) {
            Attribute newElement = (Attribute)Timeline.this.core$().graph().concept(Attribute.class).createNode(this.name, Timeline.this.core$()).as(Attribute.class);
            newElement.core$().set((Layer)newElement, "magnitude", Collections.singletonList(magnitude));
            newElement.core$().set((Layer)newElement, "from", Collections.singletonList(from));
            return newElement;
        }
    }

    public class Clear {
        public void attribute(Predicate<Attribute> filter) {
            new ArrayList<Attribute>(Timeline.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

