/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Attribute;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Reel
extends Layer
implements Component,
Terminal {
    protected Entity entity;
    protected List<Signal> signalList = new ArrayList<Signal>();

    public Reel(Node node) {
        super(node);
    }

    public Entity entity() {
        return this.entity;
    }

    public Reel entity(Entity value) {
        this.entity = value;
        return this;
    }

    public List<Signal> signalList() {
        return Collections.unmodifiableList(this.signalList);
    }

    public Signal signal(int index) {
        return this.signalList.get(index);
    }

    public List<Signal> signalList(Predicate<Signal> predicate) {
        return this.signalList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Signal signal(Predicate<Signal> predicate) {
        return this.signalList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Signal>(this.signalList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("entity", this.entity != null ? new ArrayList<Entity>(Collections.singletonList(this.entity)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Reel$Signal")) {
            this.signalList.add((Signal)node.as(Signal.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Reel$Signal")) {
            this.signalList.remove(node.as(Signal.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("entity")) {
            this.entity = (Entity)((Object)NodeLoader.load(values, Entity.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("entity")) {
            this.entity = values.get(0) != null ? (Entity)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Entity.class) : null;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class Signal
    extends Layer
    implements Terminal {
        protected Datalake.Tank.Message tank;
        protected Attribute attribute;
        protected Operation operation;

        public Signal(Node node) {
            super(node);
        }

        public Datalake.Tank.Message tank() {
            return this.tank;
        }

        public Attribute attribute() {
            return this.attribute;
        }

        public Operation operation() {
            return this.operation;
        }

        public Signal tank(Datalake.Tank.Message value) {
            this.tank = value;
            return this;
        }

        public Signal attribute(Attribute value) {
            this.attribute = value;
            return this;
        }

        public Signal operation(Operation value) {
            this.operation = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("tank", this.tank != null ? new ArrayList<Datalake.Tank.Message>(Collections.singletonList(this.tank)) : Collections.emptyList());
            map.put("attribute", this.attribute != null ? new ArrayList<Attribute>(Collections.singletonList(this.attribute)) : Collections.emptyList());
            map.put("operation", new ArrayList<Operation>(Collections.singletonList(this.operation)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (Datalake.Tank.Message)((Object)NodeLoader.load(values, Datalake.Tank.Message.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("attribute")) {
                this.attribute = (Attribute)((Object)NodeLoader.load(values, Attribute.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("operation")) {
                this.operation = (Operation)((Object)WordLoader.load(values, Operation.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = values.get(0) != null ? (Datalake.Tank.Message)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Datalake.Tank.Message.class) : null;
            } else if (name.equalsIgnoreCase("attribute")) {
                this.attribute = values.get(0) != null ? (Attribute)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Attribute.class) : null;
            } else if (name.equalsIgnoreCase("operation")) {
                this.operation = (Operation)((Object)values.get(0));
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public static enum Operation {
            Append,
            Set;

        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Signal signal(Attribute attribute, Signal.Operation operation) {
            Signal newElement = (Signal)Reel.this.core$().graph().concept(Signal.class).createNode(this.name, Reel.this.core$()).as(Signal.class);
            newElement.core$().set((Layer)newElement, "attribute", Collections.singletonList(attribute));
            newElement.core$().set((Layer)newElement, "operation", Collections.singletonList(operation));
            return newElement;
        }
    }

    public class Clear {
        public void signal(Predicate<Signal> filter) {
            new ArrayList<Signal>(Reel.this.signalList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

