/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Reel;
import io.intino.datahub.model.Struct;
import io.intino.datahub.model.Timeline;
import io.intino.datahub.model.rules.DayOfWeek;
import io.intino.datahub.model.rules.SnapshotScale;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Datamart
extends Layer
implements Terminal {
    protected Snapshots snapshots;
    protected List<Entity> entityList = new ArrayList<Entity>();
    protected List<Struct> structList = new ArrayList<Struct>();
    protected List<Timeline> timelineList = new ArrayList<Timeline>();
    protected List<Reel> reelList = new ArrayList<Reel>();

    public Datamart(Node node) {
        super(node);
    }

    public Snapshots snapshots() {
        return this.snapshots;
    }

    public List<Entity> entityList() {
        return Collections.unmodifiableList(this.entityList);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public List<Entity> entityList(Predicate<Entity> predicate) {
        return this.entityList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Entity entity(Predicate<Entity> predicate) {
        return this.entityList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Struct> structList() {
        return Collections.unmodifiableList(this.structList);
    }

    public Struct struct(int index) {
        return this.structList.get(index);
    }

    public List<Struct> structList(Predicate<Struct> predicate) {
        return this.structList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Struct struct(Predicate<Struct> predicate) {
        return this.structList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Timeline> timelineList() {
        return Collections.unmodifiableList(this.timelineList);
    }

    public Timeline timeline(int index) {
        return this.timelineList.get(index);
    }

    public List<Timeline> timelineList(Predicate<Timeline> predicate) {
        return this.timelineList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Timeline timeline(Predicate<Timeline> predicate) {
        return this.timelineList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Reel> reelList() {
        return Collections.unmodifiableList(this.reelList);
    }

    public Reel reel(int index) {
        return this.reelList.get(index);
    }

    public List<Reel> reelList(Predicate<Reel> predicate) {
        return this.reelList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Reel reel(Predicate<Reel> predicate) {
        return this.reelList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.snapshots != null) {
            components.add(this.snapshots.core$());
        }
        new ArrayList<Entity>(this.entityList).forEach(c -> components.add(c.core$()));
        new ArrayList<Struct>(this.structList).forEach(c -> components.add(c.core$()));
        new ArrayList<Timeline>(this.timelineList).forEach(c -> components.add(c.core$()));
        new ArrayList<Reel>(this.reelList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Datamart$Snapshots")) {
            this.snapshots = (Snapshots)node.as(Snapshots.class);
        }
        if (node.is("Entity")) {
            this.entityList.add((Entity)node.as(Entity.class));
        }
        if (node.is("Struct")) {
            this.structList.add((Struct)node.as(Struct.class));
        }
        if (node.is("Timeline")) {
            this.timelineList.add((Timeline)node.as(Timeline.class));
        }
        if (node.is("Reel")) {
            this.reelList.add((Reel)node.as(Reel.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Datamart$Snapshots")) {
            this.snapshots = null;
        }
        if (node.is("Entity")) {
            this.entityList.remove(node.as(Entity.class));
        }
        if (node.is("Struct")) {
            this.structList.remove(node.as(Struct.class));
        }
        if (node.is("Timeline")) {
            this.timelineList.remove(node.as(Timeline.class));
        }
        if (node.is("Reel")) {
            this.reelList.remove(node.as(Reel.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class Snapshots
    extends Layer
    implements Terminal {
        protected SnapshotScale scale;
        protected DayOfWeek firstDayOfWeek;

        public Snapshots(Node node) {
            super(node);
        }

        public SnapshotScale scale() {
            return this.scale;
        }

        public DayOfWeek firstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public Snapshots scale(SnapshotScale value) {
            this.scale = value;
            return this;
        }

        public Snapshots firstDayOfWeek(DayOfWeek value) {
            this.firstDayOfWeek = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("scale", new ArrayList<SnapshotScale>(Collections.singletonList(this.scale)));
            map.put("firstDayOfWeek", new ArrayList<DayOfWeek>(Collections.singletonList(this.firstDayOfWeek)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("scale")) {
                this.scale = (SnapshotScale)((Object)WordLoader.load(values, SnapshotScale.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("firstDayOfWeek")) {
                this.firstDayOfWeek = (DayOfWeek)((Object)WordLoader.load(values, DayOfWeek.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("scale")) {
                this.scale = (SnapshotScale)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("firstDayOfWeek")) {
                this.firstDayOfWeek = (DayOfWeek)((Object)values.get(0));
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Snapshots snapshots() {
            Snapshots newElement = (Snapshots)Datamart.this.core$().graph().concept(Snapshots.class).createNode(this.name, Datamart.this.core$()).as(Snapshots.class);
            return newElement;
        }

        public Entity entity() {
            Entity newElement = (Entity)Datamart.this.core$().graph().concept(Entity.class).createNode(this.name, Datamart.this.core$()).as(Entity.class);
            return newElement;
        }

        public Struct struct() {
            Struct newElement = (Struct)Datamart.this.core$().graph().concept(Struct.class).createNode(this.name, Datamart.this.core$()).as(Struct.class);
            return newElement;
        }

        public Timeline timeline(Datalake.Tank.Measurement tank, Entity entity) {
            Timeline newElement = (Timeline)Datamart.this.core$().graph().concept(Timeline.class).createNode(this.name, Datamart.this.core$()).as(Timeline.class);
            newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
            newElement.core$().set((Layer)newElement, "entity", Collections.singletonList(entity));
            return newElement;
        }

        public Reel reel() {
            Reel newElement = (Reel)Datamart.this.core$().graph().concept(Reel.class).createNode(this.name, Datamart.this.core$()).as(Reel.class);
            return newElement;
        }
    }

    public class Clear {
        public void entity(Predicate<Entity> filter) {
            new ArrayList<Entity>(Datamart.this.entityList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void struct(Predicate<Struct> filter) {
            new ArrayList<Struct>(Datamart.this.structList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void timeline(Predicate<Timeline> filter) {
            new ArrayList<Timeline>(Datamart.this.timelineList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void reel(Predicate<Reel> filter) {
            new ArrayList<Reel>(Datamart.this.reelList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

