/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.Timeline;
import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.TimelineFile;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class TimelineMounter
extends MasterDatamartMounter {
    public TimelineMounter(MasterDatamart datamart) {
        super(datamart);
    }

    @Override
    public void mount(Event event) {
        MeasurementEvent e;
        if (event instanceof MeasurementEvent) {
            e = (MeasurementEvent)event;
            this.mount(e);
        }
        if (event instanceof MessageEvent) {
            e = (MessageEvent)event;
            this.mount(e.toMessage());
        }
    }

    @Override
    public void mount(Message message) {
        if (message == null) {
            return;
        }
        if (this.isAssertion(message)) {
            this.mountAssertion(new MessageEvent(message));
        } else {
            this.mount(TimelineMounter.measurementEvent(message));
        }
    }

    private boolean isAssertion(Message message) {
        return this.datamart.definition().timelineList().stream().anyMatch(t -> t.entity().name$().equals(message.type()));
    }

    public void mount(MeasurementEvent event) {
        try {
            if (event.ss() == null) {
                return;
            }
            String ss = this.withOutParameters(event.ss());
            TimelineFile timelineFile = this.datamart.timelineStore().get(ss);
            if (timelineFile == null) {
                timelineFile = this.createTimelineFile(event, ss);
            }
            this.update(timelineFile, event);
        }
        catch (Exception e) {
            Logger.error((String)("Could not mount event " + event.type() + ", ss = " + event.ss() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(TimelineFile tlFile, MeasurementEvent event) {
        TimelineFile.DataSession session = null;
        try {
            session = tlFile.add();
            TimelineMounter.checkTs(event.ts(), tlFile, session);
            if (tlFile.next().isBefore(event.ts()) || Math.abs(Duration.between(event.ts(), tlFile.next()).getSeconds()) / 60L <= 1L) {
                this.update(event, session);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        finally {
            this.close(session);
        }
    }

    private void close(TimelineFile.DataSession session) {
        if (session == null) {
            return;
        }
        try {
            session.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void checkTs(Instant ts, TimelineFile tlFile, TimelineFile.DataSession session) throws IOException {
        long lapse = Duration.between(ts, tlFile.next()).getSeconds();
        if (lapse > tlFile.period().duration() * 2L) {
            session.set(ts);
        }
    }

    private void update(MeasurementEvent event, TimelineFile.DataSession session) {
        IntStream.range(0, event.measurements().length).forEach(i -> session.set(event.measurements()[i].name(), event.values()[i]));
    }

    private static MeasurementEvent measurementEvent(Message message) {
        return new MeasurementEvent(message.type(), message.get("ss").asString(), message.get("ts").asInstant(), (String[])message.get("measurements").as(String[].class), Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    private TimelineFile createTimelineFile(MeasurementEvent event, String ss) throws IOException {
        File file = new File(this.box().datamartTimelinesDirectory(this.datamart.name()), event.type() + File.separator + ss + ".timeline");
        file.getParentFile().mkdirs();
        TimelineFile timelineFile = TimelineFile.create((File)file, (String)ss);
        Timeline timeline = this.datamart.definition().timelineList().stream().filter(t -> t.tank().sensor().name$().equals(event.type())).findFirst().orElseThrow(() -> new IOException("Tank not found"));
        timelineFile.timeModel(event.ts(), new Period(timeline.tank().period(), timeline.tank().periodScale().chronoUnit()));
        timelineFile.sensorModel(this.sensorModel(this.datamart.entityStore().get(ss), timeline));
        return timelineFile;
    }

    private void mountAssertion(MessageEvent assertion) {
        this.datamart.definition().timelineList().stream().filter(t -> t.entity().name$().equals(assertion.type())).findFirst().ifPresent(t -> {
            try {
                File file = new File(this.box().datamartTimelinesDirectory(this.datamart.name()) + ".timeline");
                File tlFile = new File(file, assertion.ss());
                if (!tlFile.exists()) {
                    return;
                }
                TimelineFile timelineFile = TimelineFile.open((File)tlFile);
                timelineFile.sensorModel(this.sensorModel(assertion.toMessage(), (Timeline)((Object)t)));
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        });
    }

    private Magnitude[] sensorModel(Message message, Timeline timeline) {
        Sensor sensor = timeline.tank().sensor();
        return (Magnitude[])sensor.magnitudeList().stream().map(m -> new Magnitude(m.id(), new Magnitude.Model(this.merge((Sensor.Magnitude)((Object)m), message, m.attributeList(), timeline.attributeList())))).toArray(Magnitude[]::new);
    }

    private Map<String, String> merge(Sensor.Magnitude m, Message message, List<Sensor.Magnitude.Attribute> magnitudeAttr, List<Timeline.Attribute> timelineAttr) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Sensor.Magnitude.Attribute attribute : magnitudeAttr) {
            attrs.put(attribute.name$(), attribute.value());
        }
        timelineAttr.stream().filter(a -> ((Object)((Object)a.magnitude())).equals((Object)m)).forEach(a -> {
            String value = this.valueOf(message, a.from());
            if (value != null) {
                attrs.put(a.name$(), value);
            }
        });
        return attrs;
    }

    private String valueOf(Message message, Entity.Attribute source) {
        return message.get(source.name$()).asString();
    }

    private String withOutParameters(String ss) {
        return ss.contains("?") ? ss.substring(0, ss.indexOf("?")) : ss;
    }
}

